// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Details of the Credentials used to connect to Backend.
 */
@Fluent
public final class BackendCredentialsContract implements JsonSerializable<BackendCredentialsContract> {
    /*
     * List of Client Certificate Ids.
     */
    private List<String> certificateIds;

    /*
     * List of Client Certificate Thumbprints. Will be ignored if certificatesIds are provided.
     */
    private List<String> certificate;

    /*
     * Query Parameter description.
     */
    private Map<String, List<String>> query;

    /*
     * Header Parameter description.
     */
    private Map<String, List<String>> headerProperty;

    /*
     * Authorization header authentication
     */
    private BackendAuthorizationHeaderCredentials authorization;

    /**
     * Creates an instance of BackendCredentialsContract class.
     */
    public BackendCredentialsContract() {
    }

    /**
     * Get the certificateIds property: List of Client Certificate Ids.
     * 
     * @return the certificateIds value.
     */
    public List<String> certificateIds() {
        return this.certificateIds;
    }

    /**
     * Set the certificateIds property: List of Client Certificate Ids.
     * 
     * @param certificateIds the certificateIds value to set.
     * @return the BackendCredentialsContract object itself.
     */
    public BackendCredentialsContract withCertificateIds(List<String> certificateIds) {
        this.certificateIds = certificateIds;
        return this;
    }

    /**
     * Get the certificate property: List of Client Certificate Thumbprints. Will be ignored if certificatesIds are
     * provided.
     * 
     * @return the certificate value.
     */
    public List<String> certificate() {
        return this.certificate;
    }

    /**
     * Set the certificate property: List of Client Certificate Thumbprints. Will be ignored if certificatesIds are
     * provided.
     * 
     * @param certificate the certificate value to set.
     * @return the BackendCredentialsContract object itself.
     */
    public BackendCredentialsContract withCertificate(List<String> certificate) {
        this.certificate = certificate;
        return this;
    }

    /**
     * Get the query property: Query Parameter description.
     * 
     * @return the query value.
     */
    public Map<String, List<String>> query() {
        return this.query;
    }

    /**
     * Set the query property: Query Parameter description.
     * 
     * @param query the query value to set.
     * @return the BackendCredentialsContract object itself.
     */
    public BackendCredentialsContract withQuery(Map<String, List<String>> query) {
        this.query = query;
        return this;
    }

    /**
     * Get the headerProperty property: Header Parameter description.
     * 
     * @return the headerProperty value.
     */
    public Map<String, List<String>> headerProperty() {
        return this.headerProperty;
    }

    /**
     * Set the headerProperty property: Header Parameter description.
     * 
     * @param headerProperty the headerProperty value to set.
     * @return the BackendCredentialsContract object itself.
     */
    public BackendCredentialsContract withHeaderProperty(Map<String, List<String>> headerProperty) {
        this.headerProperty = headerProperty;
        return this;
    }

    /**
     * Get the authorization property: Authorization header authentication.
     * 
     * @return the authorization value.
     */
    public BackendAuthorizationHeaderCredentials authorization() {
        return this.authorization;
    }

    /**
     * Set the authorization property: Authorization header authentication.
     * 
     * @param authorization the authorization value to set.
     * @return the BackendCredentialsContract object itself.
     */
    public BackendCredentialsContract withAuthorization(BackendAuthorizationHeaderCredentials authorization) {
        this.authorization = authorization;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (authorization() != null) {
            authorization().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("certificateIds", this.certificateIds,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("certificate", this.certificate, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("query", this.query,
            (writer, element) -> writer.writeArray(element, (writer1, element1) -> writer1.writeString(element1)));
        jsonWriter.writeMapField("header", this.headerProperty,
            (writer, element) -> writer.writeArray(element, (writer1, element1) -> writer1.writeString(element1)));
        jsonWriter.writeJsonField("authorization", this.authorization);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BackendCredentialsContract from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BackendCredentialsContract if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BackendCredentialsContract.
     */
    public static BackendCredentialsContract fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BackendCredentialsContract deserializedBackendCredentialsContract = new BackendCredentialsContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("certificateIds".equals(fieldName)) {
                    List<String> certificateIds = reader.readArray(reader1 -> reader1.getString());
                    deserializedBackendCredentialsContract.certificateIds = certificateIds;
                } else if ("certificate".equals(fieldName)) {
                    List<String> certificate = reader.readArray(reader1 -> reader1.getString());
                    deserializedBackendCredentialsContract.certificate = certificate;
                } else if ("query".equals(fieldName)) {
                    Map<String, List<String>> query
                        = reader.readMap(reader1 -> reader1.readArray(reader2 -> reader2.getString()));
                    deserializedBackendCredentialsContract.query = query;
                } else if ("header".equals(fieldName)) {
                    Map<String, List<String>> headerProperty
                        = reader.readMap(reader1 -> reader1.readArray(reader2 -> reader2.getString()));
                    deserializedBackendCredentialsContract.headerProperty = headerProperty;
                } else if ("authorization".equals(fieldName)) {
                    deserializedBackendCredentialsContract.authorization
                        = BackendAuthorizationHeaderCredentials.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBackendCredentialsContract;
        });
    }
}
