// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Backend pool service information.
 */
@Fluent
public final class BackendPoolItem implements JsonSerializable<BackendPoolItem> {
    /*
     * The unique ARM id of the backend entity. The ARM id should refer to an already existing backend entity.
     */
    private String id;

    /*
     * The weight of the backend entity in the backend pool. Must be between 0 and 100. It can be also null if the value
     * not specified.
     */
    private Integer weight;

    /*
     * The priority of the backend entity in the backend pool. Must be between 0 and 100. It can be also null if the
     * value not specified.
     */
    private Integer priority;

    /**
     * Creates an instance of BackendPoolItem class.
     */
    public BackendPoolItem() {
    }

    /**
     * Get the id property: The unique ARM id of the backend entity. The ARM id should refer to an already existing
     * backend entity.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The unique ARM id of the backend entity. The ARM id should refer to an already existing
     * backend entity.
     * 
     * @param id the id value to set.
     * @return the BackendPoolItem object itself.
     */
    public BackendPoolItem withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the weight property: The weight of the backend entity in the backend pool. Must be between 0 and 100. It can
     * be also null if the value not specified.
     * 
     * @return the weight value.
     */
    public Integer weight() {
        return this.weight;
    }

    /**
     * Set the weight property: The weight of the backend entity in the backend pool. Must be between 0 and 100. It can
     * be also null if the value not specified.
     * 
     * @param weight the weight value to set.
     * @return the BackendPoolItem object itself.
     */
    public BackendPoolItem withWeight(Integer weight) {
        this.weight = weight;
        return this;
    }

    /**
     * Get the priority property: The priority of the backend entity in the backend pool. Must be between 0 and 100. It
     * can be also null if the value not specified.
     * 
     * @return the priority value.
     */
    public Integer priority() {
        return this.priority;
    }

    /**
     * Set the priority property: The priority of the backend entity in the backend pool. Must be between 0 and 100. It
     * can be also null if the value not specified.
     * 
     * @param priority the priority value to set.
     * @return the BackendPoolItem object itself.
     */
    public BackendPoolItem withPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (id() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property id in model BackendPoolItem"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(BackendPoolItem.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeNumberField("weight", this.weight);
        jsonWriter.writeNumberField("priority", this.priority);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BackendPoolItem from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BackendPoolItem if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the BackendPoolItem.
     */
    public static BackendPoolItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BackendPoolItem deserializedBackendPoolItem = new BackendPoolItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedBackendPoolItem.id = reader.getString();
                } else if ("weight".equals(fieldName)) {
                    deserializedBackendPoolItem.weight = reader.getNullable(JsonReader::getInt);
                } else if ("priority".equals(fieldName)) {
                    deserializedBackendPoolItem.priority = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBackendPoolItem;
        });
    }
}
