// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Backend communication protocol.
 */
public final class BackendProtocol extends ExpandableStringEnum<BackendProtocol> {
    /**
     * Static value http for BackendProtocol.
     */
    public static final BackendProtocol HTTP = fromString("http");

    /**
     * Static value soap for BackendProtocol.
     */
    public static final BackendProtocol SOAP = fromString("soap");

    /**
     * Creates a new instance of BackendProtocol value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public BackendProtocol() {
    }

    /**
     * Creates or finds a BackendProtocol from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding BackendProtocol.
     */
    public static BackendProtocol fromString(String name) {
        return fromString(name, BackendProtocol.class);
    }

    /**
     * Gets known BackendProtocol values.
     * 
     * @return known BackendProtocol values.
     */
    public static Collection<BackendProtocol> values() {
        return values(BackendProtocol.class);
    }
}
