// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Details of the Backend WebProxy Server to use in the Request to Backend.
 */
@Fluent
public final class BackendProxyContract implements JsonSerializable<BackendProxyContract> {
    /*
     * WebProxy Server AbsoluteUri property which includes the entire URI stored in the Uri instance, including all
     * fragments and query strings.
     */
    private String url;

    /*
     * Username to connect to the WebProxy server
     */
    private String username;

    /*
     * Password to connect to the WebProxy Server
     */
    private String password;

    /**
     * Creates an instance of BackendProxyContract class.
     */
    public BackendProxyContract() {
    }

    /**
     * Get the url property: WebProxy Server AbsoluteUri property which includes the entire URI stored in the Uri
     * instance, including all fragments and query strings.
     * 
     * @return the url value.
     */
    public String url() {
        return this.url;
    }

    /**
     * Set the url property: WebProxy Server AbsoluteUri property which includes the entire URI stored in the Uri
     * instance, including all fragments and query strings.
     * 
     * @param url the url value to set.
     * @return the BackendProxyContract object itself.
     */
    public BackendProxyContract withUrl(String url) {
        this.url = url;
        return this;
    }

    /**
     * Get the username property: Username to connect to the WebProxy server.
     * 
     * @return the username value.
     */
    public String username() {
        return this.username;
    }

    /**
     * Set the username property: Username to connect to the WebProxy server.
     * 
     * @param username the username value to set.
     * @return the BackendProxyContract object itself.
     */
    public BackendProxyContract withUsername(String username) {
        this.username = username;
        return this;
    }

    /**
     * Get the password property: Password to connect to the WebProxy Server.
     * 
     * @return the password value.
     */
    public String password() {
        return this.password;
    }

    /**
     * Set the password property: Password to connect to the WebProxy Server.
     * 
     * @param password the password value to set.
     * @return the BackendProxyContract object itself.
     */
    public BackendProxyContract withPassword(String password) {
        this.password = password;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (url() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property url in model BackendProxyContract"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(BackendProxyContract.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("username", this.username);
        jsonWriter.writeStringField("password", this.password);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BackendProxyContract from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BackendProxyContract if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the BackendProxyContract.
     */
    public static BackendProxyContract fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BackendProxyContract deserializedBackendProxyContract = new BackendProxyContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("url".equals(fieldName)) {
                    deserializedBackendProxyContract.url = reader.getString();
                } else if ("username".equals(fieldName)) {
                    deserializedBackendProxyContract.username = reader.getString();
                } else if ("password".equals(fieldName)) {
                    deserializedBackendProxyContract.password = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBackendProxyContract;
        });
    }
}
