// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.BackendReconnectProperties;
import java.io.IOException;
import java.time.Duration;

/**
 * Reconnect request parameters.
 */
@Fluent
public final class BackendReconnectContract extends ProxyResource {
    /*
     * Reconnect request properties.
     */
    private BackendReconnectProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of BackendReconnectContract class.
     */
    public BackendReconnectContract() {
    }

    /**
     * Get the innerProperties property: Reconnect request properties.
     * 
     * @return the innerProperties value.
     */
    private BackendReconnectProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the after property: Duration in ISO8601 format after which reconnect will be initiated. Minimum duration of
     * the Reconnect is PT2M.
     * 
     * @return the after value.
     */
    public Duration after() {
        return this.innerProperties() == null ? null : this.innerProperties().after();
    }

    /**
     * Set the after property: Duration in ISO8601 format after which reconnect will be initiated. Minimum duration of
     * the Reconnect is PT2M.
     * 
     * @param after the after value to set.
     * @return the BackendReconnectContract object itself.
     */
    public BackendReconnectContract withAfter(Duration after) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackendReconnectProperties();
        }
        this.innerProperties().withAfter(after);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BackendReconnectContract from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BackendReconnectContract if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the BackendReconnectContract.
     */
    public static BackendReconnectContract fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BackendReconnectContract deserializedBackendReconnectContract = new BackendReconnectContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedBackendReconnectContract.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedBackendReconnectContract.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedBackendReconnectContract.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedBackendReconnectContract.innerProperties = BackendReconnectProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBackendReconnectContract;
        });
    }
}
