// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Information regarding how the subnet to which the gateway should be injected.
 */
@Fluent
public final class BackendSubnetConfiguration implements JsonSerializable<BackendSubnetConfiguration> {
    /*
     * The ARM ID of the subnet in which the backend systems are hosted.
     */
    private String id;

    /**
     * Creates an instance of BackendSubnetConfiguration class.
     */
    public BackendSubnetConfiguration() {
    }

    /**
     * Get the id property: The ARM ID of the subnet in which the backend systems are hosted.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The ARM ID of the subnet in which the backend systems are hosted.
     * 
     * @param id the id value to set.
     * @return the BackendSubnetConfiguration object itself.
     */
    public BackendSubnetConfiguration withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BackendSubnetConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BackendSubnetConfiguration if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BackendSubnetConfiguration.
     */
    public static BackendSubnetConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BackendSubnetConfiguration deserializedBackendSubnetConfiguration = new BackendSubnetConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedBackendSubnetConfiguration.id = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBackendSubnetConfiguration;
        });
    }
}
