// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties controlling TLS Certificate Validation.
 */
@Fluent
public final class BackendTlsProperties implements JsonSerializable<BackendTlsProperties> {
    /*
     * Flag indicating whether SSL certificate chain validation should be done when using self-signed certificates for
     * this backend host.
     */
    private Boolean validateCertificateChain;

    /*
     * Flag indicating whether SSL certificate name validation should be done when using self-signed certificates for
     * this backend host.
     */
    private Boolean validateCertificateName;

    /**
     * Creates an instance of BackendTlsProperties class.
     */
    public BackendTlsProperties() {
    }

    /**
     * Get the validateCertificateChain property: Flag indicating whether SSL certificate chain validation should be
     * done when using self-signed certificates for this backend host.
     * 
     * @return the validateCertificateChain value.
     */
    public Boolean validateCertificateChain() {
        return this.validateCertificateChain;
    }

    /**
     * Set the validateCertificateChain property: Flag indicating whether SSL certificate chain validation should be
     * done when using self-signed certificates for this backend host.
     * 
     * @param validateCertificateChain the validateCertificateChain value to set.
     * @return the BackendTlsProperties object itself.
     */
    public BackendTlsProperties withValidateCertificateChain(Boolean validateCertificateChain) {
        this.validateCertificateChain = validateCertificateChain;
        return this;
    }

    /**
     * Get the validateCertificateName property: Flag indicating whether SSL certificate name validation should be done
     * when using self-signed certificates for this backend host.
     * 
     * @return the validateCertificateName value.
     */
    public Boolean validateCertificateName() {
        return this.validateCertificateName;
    }

    /**
     * Set the validateCertificateName property: Flag indicating whether SSL certificate name validation should be done
     * when using self-signed certificates for this backend host.
     * 
     * @param validateCertificateName the validateCertificateName value to set.
     * @return the BackendTlsProperties object itself.
     */
    public BackendTlsProperties withValidateCertificateName(Boolean validateCertificateName) {
        this.validateCertificateName = validateCertificateName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("validateCertificateChain", this.validateCertificateChain);
        jsonWriter.writeBooleanField("validateCertificateName", this.validateCertificateName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BackendTlsProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BackendTlsProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BackendTlsProperties.
     */
    public static BackendTlsProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BackendTlsProperties deserializedBackendTlsProperties = new BackendTlsProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("validateCertificateChain".equals(fieldName)) {
                    deserializedBackendTlsProperties.validateCertificateChain
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("validateCertificateName".equals(fieldName)) {
                    deserializedBackendTlsProperties.validateCertificateName
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBackendTlsProperties;
        });
    }
}
