// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Body logging settings.
 */
@Fluent
public final class BodyDiagnosticSettings implements JsonSerializable<BodyDiagnosticSettings> {
    /*
     * Number of request body bytes to log.
     */
    private Integer bytes;

    /**
     * Creates an instance of BodyDiagnosticSettings class.
     */
    public BodyDiagnosticSettings() {
    }

    /**
     * Get the bytes property: Number of request body bytes to log.
     * 
     * @return the bytes value.
     */
    public Integer bytes() {
        return this.bytes;
    }

    /**
     * Set the bytes property: Number of request body bytes to log.
     * 
     * @param bytes the bytes value to set.
     * @return the BodyDiagnosticSettings object itself.
     */
    public BodyDiagnosticSettings withBytes(Integer bytes) {
        this.bytes = bytes;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("bytes", this.bytes);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BodyDiagnosticSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BodyDiagnosticSettings if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BodyDiagnosticSettings.
     */
    public static BodyDiagnosticSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BodyDiagnosticSettings deserializedBodyDiagnosticSettings = new BodyDiagnosticSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("bytes".equals(fieldName)) {
                    deserializedBodyDiagnosticSettings.bytes = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBodyDiagnosticSettings;
        });
    }
}
