// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Certificate configuration which consist of non-trusted intermediates and root certificates.
 */
@Fluent
public final class CertificateConfiguration implements JsonSerializable<CertificateConfiguration> {
    /*
     * Base64 Encoded certificate.
     */
    private String encodedCertificate;

    /*
     * Certificate Password.
     */
    private String certificatePassword;

    /*
     * The System.Security.Cryptography.x509certificates.StoreName certificate store location. Only Root and
     * CertificateAuthority are valid locations.
     */
    private CertificateConfigurationStoreName storeName;

    /*
     * Certificate information.
     */
    private CertificateInformation certificate;

    /**
     * Creates an instance of CertificateConfiguration class.
     */
    public CertificateConfiguration() {
    }

    /**
     * Get the encodedCertificate property: Base64 Encoded certificate.
     * 
     * @return the encodedCertificate value.
     */
    public String encodedCertificate() {
        return this.encodedCertificate;
    }

    /**
     * Set the encodedCertificate property: Base64 Encoded certificate.
     * 
     * @param encodedCertificate the encodedCertificate value to set.
     * @return the CertificateConfiguration object itself.
     */
    public CertificateConfiguration withEncodedCertificate(String encodedCertificate) {
        this.encodedCertificate = encodedCertificate;
        return this;
    }

    /**
     * Get the certificatePassword property: Certificate Password.
     * 
     * @return the certificatePassword value.
     */
    public String certificatePassword() {
        return this.certificatePassword;
    }

    /**
     * Set the certificatePassword property: Certificate Password.
     * 
     * @param certificatePassword the certificatePassword value to set.
     * @return the CertificateConfiguration object itself.
     */
    public CertificateConfiguration withCertificatePassword(String certificatePassword) {
        this.certificatePassword = certificatePassword;
        return this;
    }

    /**
     * Get the storeName property: The System.Security.Cryptography.x509certificates.StoreName certificate store
     * location. Only Root and CertificateAuthority are valid locations.
     * 
     * @return the storeName value.
     */
    public CertificateConfigurationStoreName storeName() {
        return this.storeName;
    }

    /**
     * Set the storeName property: The System.Security.Cryptography.x509certificates.StoreName certificate store
     * location. Only Root and CertificateAuthority are valid locations.
     * 
     * @param storeName the storeName value to set.
     * @return the CertificateConfiguration object itself.
     */
    public CertificateConfiguration withStoreName(CertificateConfigurationStoreName storeName) {
        this.storeName = storeName;
        return this;
    }

    /**
     * Get the certificate property: Certificate information.
     * 
     * @return the certificate value.
     */
    public CertificateInformation certificate() {
        return this.certificate;
    }

    /**
     * Set the certificate property: Certificate information.
     * 
     * @param certificate the certificate value to set.
     * @return the CertificateConfiguration object itself.
     */
    public CertificateConfiguration withCertificate(CertificateInformation certificate) {
        this.certificate = certificate;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (storeName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property storeName in model CertificateConfiguration"));
        }
        if (certificate() != null) {
            certificate().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CertificateConfiguration.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storeName", this.storeName == null ? null : this.storeName.toString());
        jsonWriter.writeStringField("encodedCertificate", this.encodedCertificate);
        jsonWriter.writeStringField("certificatePassword", this.certificatePassword);
        jsonWriter.writeJsonField("certificate", this.certificate);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CertificateConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CertificateConfiguration if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CertificateConfiguration.
     */
    public static CertificateConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CertificateConfiguration deserializedCertificateConfiguration = new CertificateConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("storeName".equals(fieldName)) {
                    deserializedCertificateConfiguration.storeName
                        = CertificateConfigurationStoreName.fromString(reader.getString());
                } else if ("encodedCertificate".equals(fieldName)) {
                    deserializedCertificateConfiguration.encodedCertificate = reader.getString();
                } else if ("certificatePassword".equals(fieldName)) {
                    deserializedCertificateConfiguration.certificatePassword = reader.getString();
                } else if ("certificate".equals(fieldName)) {
                    deserializedCertificateConfiguration.certificate = CertificateInformation.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCertificateConfiguration;
        });
    }
}
