// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

/**
 * The trip conditions of the circuit breaker.
 */
@Fluent
public final class CircuitBreakerFailureCondition implements JsonSerializable<CircuitBreakerFailureCondition> {
    /*
     * The threshold for opening the circuit.
     */
    private Long count;

    /*
     * The threshold for opening the circuit.
     */
    private Long percentage;

    /*
     * The interval during which the failures are counted.
     */
    private Duration interval;

    /*
     * The status code ranges which are considered as failure.
     */
    private List<FailureStatusCodeRange> statusCodeRanges;

    /*
     * The error reasons which are considered as failure.
     */
    private List<String> errorReasons;

    /**
     * Creates an instance of CircuitBreakerFailureCondition class.
     */
    public CircuitBreakerFailureCondition() {
    }

    /**
     * Get the count property: The threshold for opening the circuit.
     * 
     * @return the count value.
     */
    public Long count() {
        return this.count;
    }

    /**
     * Set the count property: The threshold for opening the circuit.
     * 
     * @param count the count value to set.
     * @return the CircuitBreakerFailureCondition object itself.
     */
    public CircuitBreakerFailureCondition withCount(Long count) {
        this.count = count;
        return this;
    }

    /**
     * Get the percentage property: The threshold for opening the circuit.
     * 
     * @return the percentage value.
     */
    public Long percentage() {
        return this.percentage;
    }

    /**
     * Set the percentage property: The threshold for opening the circuit.
     * 
     * @param percentage the percentage value to set.
     * @return the CircuitBreakerFailureCondition object itself.
     */
    public CircuitBreakerFailureCondition withPercentage(Long percentage) {
        this.percentage = percentage;
        return this;
    }

    /**
     * Get the interval property: The interval during which the failures are counted.
     * 
     * @return the interval value.
     */
    public Duration interval() {
        return this.interval;
    }

    /**
     * Set the interval property: The interval during which the failures are counted.
     * 
     * @param interval the interval value to set.
     * @return the CircuitBreakerFailureCondition object itself.
     */
    public CircuitBreakerFailureCondition withInterval(Duration interval) {
        this.interval = interval;
        return this;
    }

    /**
     * Get the statusCodeRanges property: The status code ranges which are considered as failure.
     * 
     * @return the statusCodeRanges value.
     */
    public List<FailureStatusCodeRange> statusCodeRanges() {
        return this.statusCodeRanges;
    }

    /**
     * Set the statusCodeRanges property: The status code ranges which are considered as failure.
     * 
     * @param statusCodeRanges the statusCodeRanges value to set.
     * @return the CircuitBreakerFailureCondition object itself.
     */
    public CircuitBreakerFailureCondition withStatusCodeRanges(List<FailureStatusCodeRange> statusCodeRanges) {
        this.statusCodeRanges = statusCodeRanges;
        return this;
    }

    /**
     * Get the errorReasons property: The error reasons which are considered as failure.
     * 
     * @return the errorReasons value.
     */
    public List<String> errorReasons() {
        return this.errorReasons;
    }

    /**
     * Set the errorReasons property: The error reasons which are considered as failure.
     * 
     * @param errorReasons the errorReasons value to set.
     * @return the CircuitBreakerFailureCondition object itself.
     */
    public CircuitBreakerFailureCondition withErrorReasons(List<String> errorReasons) {
        this.errorReasons = errorReasons;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (statusCodeRanges() != null) {
            statusCodeRanges().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("count", this.count);
        jsonWriter.writeNumberField("percentage", this.percentage);
        jsonWriter.writeStringField("interval", CoreUtils.durationToStringWithDays(this.interval));
        jsonWriter.writeArrayField("statusCodeRanges", this.statusCodeRanges,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("errorReasons", this.errorReasons, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CircuitBreakerFailureCondition from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CircuitBreakerFailureCondition if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CircuitBreakerFailureCondition.
     */
    public static CircuitBreakerFailureCondition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CircuitBreakerFailureCondition deserializedCircuitBreakerFailureCondition
                = new CircuitBreakerFailureCondition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("count".equals(fieldName)) {
                    deserializedCircuitBreakerFailureCondition.count = reader.getNullable(JsonReader::getLong);
                } else if ("percentage".equals(fieldName)) {
                    deserializedCircuitBreakerFailureCondition.percentage = reader.getNullable(JsonReader::getLong);
                } else if ("interval".equals(fieldName)) {
                    deserializedCircuitBreakerFailureCondition.interval
                        = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                } else if ("statusCodeRanges".equals(fieldName)) {
                    List<FailureStatusCodeRange> statusCodeRanges
                        = reader.readArray(reader1 -> FailureStatusCodeRange.fromJson(reader1));
                    deserializedCircuitBreakerFailureCondition.statusCodeRanges = statusCodeRanges;
                } else if ("errorReasons".equals(fieldName)) {
                    List<String> errorReasons = reader.readArray(reader1 -> reader1.getString());
                    deserializedCircuitBreakerFailureCondition.errorReasons = errorReasons;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCircuitBreakerFailureCondition;
        });
    }
}
