// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;

/**
 * Rule configuration to trip the backend.
 */
@Fluent
public final class CircuitBreakerRule implements JsonSerializable<CircuitBreakerRule> {
    /*
     * The rule name.
     */
    private String name;

    /*
     * The conditions for tripping the circuit breaker.
     */
    private CircuitBreakerFailureCondition failureCondition;

    /*
     * The duration for which the circuit will be tripped.
     */
    private Duration tripDuration;

    /*
     * flag to accept Retry-After header from the backend.
     */
    private Boolean acceptRetryAfter;

    /**
     * Creates an instance of CircuitBreakerRule class.
     */
    public CircuitBreakerRule() {
    }

    /**
     * Get the name property: The rule name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The rule name.
     * 
     * @param name the name value to set.
     * @return the CircuitBreakerRule object itself.
     */
    public CircuitBreakerRule withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the failureCondition property: The conditions for tripping the circuit breaker.
     * 
     * @return the failureCondition value.
     */
    public CircuitBreakerFailureCondition failureCondition() {
        return this.failureCondition;
    }

    /**
     * Set the failureCondition property: The conditions for tripping the circuit breaker.
     * 
     * @param failureCondition the failureCondition value to set.
     * @return the CircuitBreakerRule object itself.
     */
    public CircuitBreakerRule withFailureCondition(CircuitBreakerFailureCondition failureCondition) {
        this.failureCondition = failureCondition;
        return this;
    }

    /**
     * Get the tripDuration property: The duration for which the circuit will be tripped.
     * 
     * @return the tripDuration value.
     */
    public Duration tripDuration() {
        return this.tripDuration;
    }

    /**
     * Set the tripDuration property: The duration for which the circuit will be tripped.
     * 
     * @param tripDuration the tripDuration value to set.
     * @return the CircuitBreakerRule object itself.
     */
    public CircuitBreakerRule withTripDuration(Duration tripDuration) {
        this.tripDuration = tripDuration;
        return this;
    }

    /**
     * Get the acceptRetryAfter property: flag to accept Retry-After header from the backend.
     * 
     * @return the acceptRetryAfter value.
     */
    public Boolean acceptRetryAfter() {
        return this.acceptRetryAfter;
    }

    /**
     * Set the acceptRetryAfter property: flag to accept Retry-After header from the backend.
     * 
     * @param acceptRetryAfter the acceptRetryAfter value to set.
     * @return the CircuitBreakerRule object itself.
     */
    public CircuitBreakerRule withAcceptRetryAfter(Boolean acceptRetryAfter) {
        this.acceptRetryAfter = acceptRetryAfter;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (failureCondition() != null) {
            failureCondition().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("failureCondition", this.failureCondition);
        jsonWriter.writeStringField("tripDuration", CoreUtils.durationToStringWithDays(this.tripDuration));
        jsonWriter.writeBooleanField("acceptRetryAfter", this.acceptRetryAfter);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CircuitBreakerRule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CircuitBreakerRule if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the CircuitBreakerRule.
     */
    public static CircuitBreakerRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CircuitBreakerRule deserializedCircuitBreakerRule = new CircuitBreakerRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedCircuitBreakerRule.name = reader.getString();
                } else if ("failureCondition".equals(fieldName)) {
                    deserializedCircuitBreakerRule.failureCondition = CircuitBreakerFailureCondition.fromJson(reader);
                } else if ("tripDuration".equals(fieldName)) {
                    deserializedCircuitBreakerRule.tripDuration
                        = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                } else if ("acceptRetryAfter".equals(fieldName)) {
                    deserializedCircuitBreakerRule.acceptRetryAfter = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCircuitBreakerRule;
        });
    }
}
