// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Information regarding the Configuration API of the API Management service.
 */
@Fluent
public final class ConfigurationApi implements JsonSerializable<ConfigurationApi> {
    /*
     * Indication whether or not the legacy Configuration API (v1) should be exposed on the API Management service.
     * Value is optional but must be 'Enabled' or 'Disabled'. If 'Disabled', legacy Configuration API (v1) will not be
     * available for self-hosted gateways. Default value is 'Enabled'
     */
    private LegacyApiState legacyApi;

    /**
     * Creates an instance of ConfigurationApi class.
     */
    public ConfigurationApi() {
    }

    /**
     * Get the legacyApi property: Indication whether or not the legacy Configuration API (v1) should be exposed on the
     * API Management service. Value is optional but must be 'Enabled' or 'Disabled'. If 'Disabled', legacy
     * Configuration API (v1) will not be available for self-hosted gateways. Default value is 'Enabled'.
     * 
     * @return the legacyApi value.
     */
    public LegacyApiState legacyApi() {
        return this.legacyApi;
    }

    /**
     * Set the legacyApi property: Indication whether or not the legacy Configuration API (v1) should be exposed on the
     * API Management service. Value is optional but must be 'Enabled' or 'Disabled'. If 'Disabled', legacy
     * Configuration API (v1) will not be available for self-hosted gateways. Default value is 'Enabled'.
     * 
     * @param legacyApi the legacyApi value to set.
     * @return the ConfigurationApi object itself.
     */
    public ConfigurationApi withLegacyApi(LegacyApiState legacyApi) {
        this.legacyApi = legacyApi;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("legacyApi", this.legacyApi == null ? null : this.legacyApi.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConfigurationApi from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConfigurationApi if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConfigurationApi.
     */
    public static ConfigurationApi fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConfigurationApi deserializedConfigurationApi = new ConfigurationApi();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("legacyApi".equals(fieldName)) {
                    deserializedConfigurationApi.legacyApi = LegacyApiState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConfigurationApi;
        });
    }
}
