// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A request to perform the connectivity check operation on a API Management service.
 */
@Fluent
public final class ConnectivityCheckRequest implements JsonSerializable<ConnectivityCheckRequest> {
    /*
     * Definitions about the connectivity check origin.
     */
    private ConnectivityCheckRequestSource source;

    /*
     * The connectivity check operation destination.
     */
    private ConnectivityCheckRequestDestination destination;

    /*
     * The IP version to be used. Only IPv4 is supported for now.
     */
    private PreferredIpVersion preferredIpVersion;

    /*
     * The request's protocol. Specific protocol configuration can be available based on this selection. The specified
     * destination address must be coherent with this value.
     */
    private ConnectivityCheckProtocol protocol;

    /*
     * Protocol-specific configuration.
     */
    private ConnectivityCheckRequestProtocolConfiguration protocolConfiguration;

    /**
     * Creates an instance of ConnectivityCheckRequest class.
     */
    public ConnectivityCheckRequest() {
    }

    /**
     * Get the source property: Definitions about the connectivity check origin.
     * 
     * @return the source value.
     */
    public ConnectivityCheckRequestSource source() {
        return this.source;
    }

    /**
     * Set the source property: Definitions about the connectivity check origin.
     * 
     * @param source the source value to set.
     * @return the ConnectivityCheckRequest object itself.
     */
    public ConnectivityCheckRequest withSource(ConnectivityCheckRequestSource source) {
        this.source = source;
        return this;
    }

    /**
     * Get the destination property: The connectivity check operation destination.
     * 
     * @return the destination value.
     */
    public ConnectivityCheckRequestDestination destination() {
        return this.destination;
    }

    /**
     * Set the destination property: The connectivity check operation destination.
     * 
     * @param destination the destination value to set.
     * @return the ConnectivityCheckRequest object itself.
     */
    public ConnectivityCheckRequest withDestination(ConnectivityCheckRequestDestination destination) {
        this.destination = destination;
        return this;
    }

    /**
     * Get the preferredIpVersion property: The IP version to be used. Only IPv4 is supported for now.
     * 
     * @return the preferredIpVersion value.
     */
    public PreferredIpVersion preferredIpVersion() {
        return this.preferredIpVersion;
    }

    /**
     * Set the preferredIpVersion property: The IP version to be used. Only IPv4 is supported for now.
     * 
     * @param preferredIpVersion the preferredIpVersion value to set.
     * @return the ConnectivityCheckRequest object itself.
     */
    public ConnectivityCheckRequest withPreferredIpVersion(PreferredIpVersion preferredIpVersion) {
        this.preferredIpVersion = preferredIpVersion;
        return this;
    }

    /**
     * Get the protocol property: The request's protocol. Specific protocol configuration can be available based on this
     * selection. The specified destination address must be coherent with this value.
     * 
     * @return the protocol value.
     */
    public ConnectivityCheckProtocol protocol() {
        return this.protocol;
    }

    /**
     * Set the protocol property: The request's protocol. Specific protocol configuration can be available based on this
     * selection. The specified destination address must be coherent with this value.
     * 
     * @param protocol the protocol value to set.
     * @return the ConnectivityCheckRequest object itself.
     */
    public ConnectivityCheckRequest withProtocol(ConnectivityCheckProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    /**
     * Get the protocolConfiguration property: Protocol-specific configuration.
     * 
     * @return the protocolConfiguration value.
     */
    public ConnectivityCheckRequestProtocolConfiguration protocolConfiguration() {
        return this.protocolConfiguration;
    }

    /**
     * Set the protocolConfiguration property: Protocol-specific configuration.
     * 
     * @param protocolConfiguration the protocolConfiguration value to set.
     * @return the ConnectivityCheckRequest object itself.
     */
    public ConnectivityCheckRequest
        withProtocolConfiguration(ConnectivityCheckRequestProtocolConfiguration protocolConfiguration) {
        this.protocolConfiguration = protocolConfiguration;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (source() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property source in model ConnectivityCheckRequest"));
        } else {
            source().validate();
        }
        if (destination() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property destination in model ConnectivityCheckRequest"));
        } else {
            destination().validate();
        }
        if (protocolConfiguration() != null) {
            protocolConfiguration().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ConnectivityCheckRequest.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("source", this.source);
        jsonWriter.writeJsonField("destination", this.destination);
        jsonWriter.writeStringField("preferredIPVersion",
            this.preferredIpVersion == null ? null : this.preferredIpVersion.toString());
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeJsonField("protocolConfiguration", this.protocolConfiguration);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectivityCheckRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectivityCheckRequest if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ConnectivityCheckRequest.
     */
    public static ConnectivityCheckRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectivityCheckRequest deserializedConnectivityCheckRequest = new ConnectivityCheckRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("source".equals(fieldName)) {
                    deserializedConnectivityCheckRequest.source = ConnectivityCheckRequestSource.fromJson(reader);
                } else if ("destination".equals(fieldName)) {
                    deserializedConnectivityCheckRequest.destination
                        = ConnectivityCheckRequestDestination.fromJson(reader);
                } else if ("preferredIPVersion".equals(fieldName)) {
                    deserializedConnectivityCheckRequest.preferredIpVersion
                        = PreferredIpVersion.fromString(reader.getString());
                } else if ("protocol".equals(fieldName)) {
                    deserializedConnectivityCheckRequest.protocol
                        = ConnectivityCheckProtocol.fromString(reader.getString());
                } else if ("protocolConfiguration".equals(fieldName)) {
                    deserializedConnectivityCheckRequest.protocolConfiguration
                        = ConnectivityCheckRequestProtocolConfiguration.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectivityCheckRequest;
        });
    }
}
