// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Protocol-specific configuration.
 */
@Fluent
public final class ConnectivityCheckRequestProtocolConfiguration
    implements JsonSerializable<ConnectivityCheckRequestProtocolConfiguration> {
    /*
     * Configuration for HTTP or HTTPS requests.
     */
    private ConnectivityCheckRequestProtocolConfigurationHttpConfiguration httpConfiguration;

    /**
     * Creates an instance of ConnectivityCheckRequestProtocolConfiguration class.
     */
    public ConnectivityCheckRequestProtocolConfiguration() {
    }

    /**
     * Get the httpConfiguration property: Configuration for HTTP or HTTPS requests.
     * 
     * @return the httpConfiguration value.
     */
    public ConnectivityCheckRequestProtocolConfigurationHttpConfiguration httpConfiguration() {
        return this.httpConfiguration;
    }

    /**
     * Set the httpConfiguration property: Configuration for HTTP or HTTPS requests.
     * 
     * @param httpConfiguration the httpConfiguration value to set.
     * @return the ConnectivityCheckRequestProtocolConfiguration object itself.
     */
    public ConnectivityCheckRequestProtocolConfiguration
        withHttpConfiguration(ConnectivityCheckRequestProtocolConfigurationHttpConfiguration httpConfiguration) {
        this.httpConfiguration = httpConfiguration;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (httpConfiguration() != null) {
            httpConfiguration().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("HTTPConfiguration", this.httpConfiguration);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectivityCheckRequestProtocolConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectivityCheckRequestProtocolConfiguration if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConnectivityCheckRequestProtocolConfiguration.
     */
    public static ConnectivityCheckRequestProtocolConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectivityCheckRequestProtocolConfiguration deserializedConnectivityCheckRequestProtocolConfiguration
                = new ConnectivityCheckRequestProtocolConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("HTTPConfiguration".equals(fieldName)) {
                    deserializedConnectivityCheckRequestProtocolConfiguration.httpConfiguration
                        = ConnectivityCheckRequestProtocolConfigurationHttpConfiguration.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectivityCheckRequestProtocolConfiguration;
        });
    }
}
