// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.resourcemanager.apimanagement.fluent.models.ConnectivityCheckResponseInner;
import java.util.List;

/**
 * An immutable client-side representation of ConnectivityCheckResponse.
 */
public interface ConnectivityCheckResponse {
    /**
     * Gets the hops property: List of hops between the source and the destination.
     * 
     * @return the hops value.
     */
    List<ConnectivityHop> hops();

    /**
     * Gets the connectionStatus property: The connection status.
     * 
     * @return the connectionStatus value.
     */
    ConnectionStatus connectionStatus();

    /**
     * Gets the avgLatencyInMs property: Average latency in milliseconds.
     * 
     * @return the avgLatencyInMs value.
     */
    Long avgLatencyInMs();

    /**
     * Gets the minLatencyInMs property: Minimum latency in milliseconds.
     * 
     * @return the minLatencyInMs value.
     */
    Long minLatencyInMs();

    /**
     * Gets the maxLatencyInMs property: Maximum latency in milliseconds.
     * 
     * @return the maxLatencyInMs value.
     */
    Long maxLatencyInMs();

    /**
     * Gets the probesSent property: Total number of probes sent.
     * 
     * @return the probesSent value.
     */
    Long probesSent();

    /**
     * Gets the probesFailed property: Number of failed probes.
     * 
     * @return the probesFailed value.
     */
    Long probesFailed();

    /**
     * Gets the inner com.azure.resourcemanager.apimanagement.fluent.models.ConnectivityCheckResponseInner object.
     * 
     * @return the inner object.
     */
    ConnectivityCheckResponseInner innerModel();
}
