// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The DataMasking model.
 */
@Fluent
public final class DataMasking implements JsonSerializable<DataMasking> {
    /*
     * Masking settings for Url query parameters
     */
    private List<DataMaskingEntity> queryParams;

    /*
     * Masking settings for headers
     */
    private List<DataMaskingEntity> headers;

    /**
     * Creates an instance of DataMasking class.
     */
    public DataMasking() {
    }

    /**
     * Get the queryParams property: Masking settings for Url query parameters.
     * 
     * @return the queryParams value.
     */
    public List<DataMaskingEntity> queryParams() {
        return this.queryParams;
    }

    /**
     * Set the queryParams property: Masking settings for Url query parameters.
     * 
     * @param queryParams the queryParams value to set.
     * @return the DataMasking object itself.
     */
    public DataMasking withQueryParams(List<DataMaskingEntity> queryParams) {
        this.queryParams = queryParams;
        return this;
    }

    /**
     * Get the headers property: Masking settings for headers.
     * 
     * @return the headers value.
     */
    public List<DataMaskingEntity> headers() {
        return this.headers;
    }

    /**
     * Set the headers property: Masking settings for headers.
     * 
     * @param headers the headers value to set.
     * @return the DataMasking object itself.
     */
    public DataMasking withHeaders(List<DataMaskingEntity> headers) {
        this.headers = headers;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (queryParams() != null) {
            queryParams().forEach(e -> e.validate());
        }
        if (headers() != null) {
            headers().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("queryParams", this.queryParams, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("headers", this.headers, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DataMasking from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DataMasking if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the DataMasking.
     */
    public static DataMasking fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DataMasking deserializedDataMasking = new DataMasking();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("queryParams".equals(fieldName)) {
                    List<DataMaskingEntity> queryParams
                        = reader.readArray(reader1 -> DataMaskingEntity.fromJson(reader1));
                    deserializedDataMasking.queryParams = queryParams;
                } else if ("headers".equals(fieldName)) {
                    List<DataMaskingEntity> headers = reader.readArray(reader1 -> DataMaskingEntity.fromJson(reader1));
                    deserializedDataMasking.headers = headers;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDataMasking;
        });
    }
}
