// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The DataMaskingEntity model.
 */
@Fluent
public final class DataMaskingEntity implements JsonSerializable<DataMaskingEntity> {
    /*
     * The name of an entity to mask (e.g. a name of a header or a query parameter).
     */
    private String value;

    /*
     * Data masking mode.
     */
    private DataMaskingMode mode;

    /**
     * Creates an instance of DataMaskingEntity class.
     */
    public DataMaskingEntity() {
    }

    /**
     * Get the value property: The name of an entity to mask (e.g. a name of a header or a query parameter).
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: The name of an entity to mask (e.g. a name of a header or a query parameter).
     * 
     * @param value the value value to set.
     * @return the DataMaskingEntity object itself.
     */
    public DataMaskingEntity withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get the mode property: Data masking mode.
     * 
     * @return the mode value.
     */
    public DataMaskingMode mode() {
        return this.mode;
    }

    /**
     * Set the mode property: Data masking mode.
     * 
     * @param mode the mode value to set.
     * @return the DataMaskingEntity object itself.
     */
    public DataMaskingEntity withMode(DataMaskingMode mode) {
        this.mode = mode;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("mode", this.mode == null ? null : this.mode.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DataMaskingEntity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DataMaskingEntity if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the DataMaskingEntity.
     */
    public static DataMaskingEntity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DataMaskingEntity deserializedDataMaskingEntity = new DataMaskingEntity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    deserializedDataMaskingEntity.value = reader.getString();
                } else if ("mode".equals(fieldName)) {
                    deserializedDataMaskingEntity.mode = DataMaskingMode.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDataMaskingEntity;
        });
    }
}
