// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.resourcemanager.apimanagement.fluent.models.DeletedServiceContractInner;
import java.time.OffsetDateTime;

/**
 * An immutable client-side representation of DeletedServiceContract.
 */
public interface DeletedServiceContract {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the location property: API Management Service Master Location.
     * 
     * @return the location value.
     */
    String location();

    /**
     * Gets the serviceId property: Fully-qualified API Management Service Resource ID.
     * 
     * @return the serviceId value.
     */
    String serviceId();

    /**
     * Gets the scheduledPurgeDate property: UTC Date and Time when the service will be automatically purged. The date
     * conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
     * 
     * @return the scheduledPurgeDate value.
     */
    OffsetDateTime scheduledPurgeDate();

    /**
     * Gets the deletionDate property: UTC Timestamp when the service was soft-deleted. The date conforms to the
     * following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
     * 
     * @return the deletionDate value.
     */
    OffsetDateTime deletionDate();

    /**
     * Gets the inner com.azure.resourcemanager.apimanagement.fluent.models.DeletedServiceContractInner object.
     * 
     * @return the inner object.
     */
    DeletedServiceContractInner innerModel();
}
