// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

/**
 * Resource collection API of DeletedServices.
 */
public interface DeletedServices {
    /**
     * Lists all soft-deleted services available for undelete for the given subscription.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged deleted API Management Services List Representation as paginated response with
     * {@link PagedIterable}.
     */
    PagedIterable<DeletedServiceContract> list();

    /**
     * Lists all soft-deleted services available for undelete for the given subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged deleted API Management Services List Representation as paginated response with
     * {@link PagedIterable}.
     */
    PagedIterable<DeletedServiceContract> list(Context context);

    /**
     * Get soft-deleted Api Management Service by name.
     * 
     * @param serviceName The name of the API Management service.
     * @param location The location of the deleted API Management service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return soft-deleted Api Management Service by name along with {@link Response}.
     */
    Response<DeletedServiceContract> getByNameWithResponse(String serviceName, String location, Context context);

    /**
     * Get soft-deleted Api Management Service by name.
     * 
     * @param serviceName The name of the API Management service.
     * @param location The location of the deleted API Management service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return soft-deleted Api Management Service by name.
     */
    DeletedServiceContract getByName(String serviceName, String location);

    /**
     * Purges Api Management Service (deletes it with no option to undelete).
     * 
     * @param serviceName The name of the API Management service.
     * @param location The location of the deleted API Management service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    DeletedServiceContract purge(String serviceName, String location);

    /**
     * Purges Api Management Service (deletes it with no option to undelete).
     * 
     * @param serviceName The name of the API Management service.
     * @param location The location of the deleted API Management service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    DeletedServiceContract purge(String serviceName, String location, Context context);
}
