// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.DiagnosticContractUpdateProperties;
import java.io.IOException;

/**
 * Diagnostic details.
 */
@Fluent
public final class DiagnosticUpdateContract extends ProxyResource {
    /*
     * Diagnostic entity contract properties.
     */
    private DiagnosticContractUpdateProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of DiagnosticUpdateContract class.
     */
    public DiagnosticUpdateContract() {
    }

    /**
     * Get the innerProperties property: Diagnostic entity contract properties.
     * 
     * @return the innerProperties value.
     */
    private DiagnosticContractUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the alwaysLog property: Specifies for what type of messages sampling settings should not apply.
     * 
     * @return the alwaysLog value.
     */
    public AlwaysLog alwaysLog() {
        return this.innerProperties() == null ? null : this.innerProperties().alwaysLog();
    }

    /**
     * Set the alwaysLog property: Specifies for what type of messages sampling settings should not apply.
     * 
     * @param alwaysLog the alwaysLog value to set.
     * @return the DiagnosticUpdateContract object itself.
     */
    public DiagnosticUpdateContract withAlwaysLog(AlwaysLog alwaysLog) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiagnosticContractUpdateProperties();
        }
        this.innerProperties().withAlwaysLog(alwaysLog);
        return this;
    }

    /**
     * Get the loggerId property: Resource Id of a target logger.
     * 
     * @return the loggerId value.
     */
    public String loggerId() {
        return this.innerProperties() == null ? null : this.innerProperties().loggerId();
    }

    /**
     * Set the loggerId property: Resource Id of a target logger.
     * 
     * @param loggerId the loggerId value to set.
     * @return the DiagnosticUpdateContract object itself.
     */
    public DiagnosticUpdateContract withLoggerId(String loggerId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiagnosticContractUpdateProperties();
        }
        this.innerProperties().withLoggerId(loggerId);
        return this;
    }

    /**
     * Get the sampling property: Sampling settings for Diagnostic.
     * 
     * @return the sampling value.
     */
    public SamplingSettings sampling() {
        return this.innerProperties() == null ? null : this.innerProperties().sampling();
    }

    /**
     * Set the sampling property: Sampling settings for Diagnostic.
     * 
     * @param sampling the sampling value to set.
     * @return the DiagnosticUpdateContract object itself.
     */
    public DiagnosticUpdateContract withSampling(SamplingSettings sampling) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiagnosticContractUpdateProperties();
        }
        this.innerProperties().withSampling(sampling);
        return this;
    }

    /**
     * Get the frontend property: Diagnostic settings for incoming/outgoing HTTP messages to the Gateway.
     * 
     * @return the frontend value.
     */
    public PipelineDiagnosticSettings frontend() {
        return this.innerProperties() == null ? null : this.innerProperties().frontend();
    }

    /**
     * Set the frontend property: Diagnostic settings for incoming/outgoing HTTP messages to the Gateway.
     * 
     * @param frontend the frontend value to set.
     * @return the DiagnosticUpdateContract object itself.
     */
    public DiagnosticUpdateContract withFrontend(PipelineDiagnosticSettings frontend) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiagnosticContractUpdateProperties();
        }
        this.innerProperties().withFrontend(frontend);
        return this;
    }

    /**
     * Get the backend property: Diagnostic settings for incoming/outgoing HTTP messages to the Backend.
     * 
     * @return the backend value.
     */
    public PipelineDiagnosticSettings backend() {
        return this.innerProperties() == null ? null : this.innerProperties().backend();
    }

    /**
     * Set the backend property: Diagnostic settings for incoming/outgoing HTTP messages to the Backend.
     * 
     * @param backend the backend value to set.
     * @return the DiagnosticUpdateContract object itself.
     */
    public DiagnosticUpdateContract withBackend(PipelineDiagnosticSettings backend) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiagnosticContractUpdateProperties();
        }
        this.innerProperties().withBackend(backend);
        return this;
    }

    /**
     * Get the logClientIp property: Log the ClientIP. Default is false.
     * 
     * @return the logClientIp value.
     */
    public Boolean logClientIp() {
        return this.innerProperties() == null ? null : this.innerProperties().logClientIp();
    }

    /**
     * Set the logClientIp property: Log the ClientIP. Default is false.
     * 
     * @param logClientIp the logClientIp value to set.
     * @return the DiagnosticUpdateContract object itself.
     */
    public DiagnosticUpdateContract withLogClientIp(Boolean logClientIp) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiagnosticContractUpdateProperties();
        }
        this.innerProperties().withLogClientIp(logClientIp);
        return this;
    }

    /**
     * Get the httpCorrelationProtocol property: Sets correlation protocol to use for Application Insights diagnostics.
     * 
     * @return the httpCorrelationProtocol value.
     */
    public HttpCorrelationProtocol httpCorrelationProtocol() {
        return this.innerProperties() == null ? null : this.innerProperties().httpCorrelationProtocol();
    }

    /**
     * Set the httpCorrelationProtocol property: Sets correlation protocol to use for Application Insights diagnostics.
     * 
     * @param httpCorrelationProtocol the httpCorrelationProtocol value to set.
     * @return the DiagnosticUpdateContract object itself.
     */
    public DiagnosticUpdateContract withHttpCorrelationProtocol(HttpCorrelationProtocol httpCorrelationProtocol) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiagnosticContractUpdateProperties();
        }
        this.innerProperties().withHttpCorrelationProtocol(httpCorrelationProtocol);
        return this;
    }

    /**
     * Get the verbosity property: The verbosity level applied to traces emitted by trace policies.
     * 
     * @return the verbosity value.
     */
    public Verbosity verbosity() {
        return this.innerProperties() == null ? null : this.innerProperties().verbosity();
    }

    /**
     * Set the verbosity property: The verbosity level applied to traces emitted by trace policies.
     * 
     * @param verbosity the verbosity value to set.
     * @return the DiagnosticUpdateContract object itself.
     */
    public DiagnosticUpdateContract withVerbosity(Verbosity verbosity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiagnosticContractUpdateProperties();
        }
        this.innerProperties().withVerbosity(verbosity);
        return this;
    }

    /**
     * Get the operationNameFormat property: The format of the Operation Name for Application Insights telemetries.
     * Default is Name.
     * 
     * @return the operationNameFormat value.
     */
    public OperationNameFormat operationNameFormat() {
        return this.innerProperties() == null ? null : this.innerProperties().operationNameFormat();
    }

    /**
     * Set the operationNameFormat property: The format of the Operation Name for Application Insights telemetries.
     * Default is Name.
     * 
     * @param operationNameFormat the operationNameFormat value to set.
     * @return the DiagnosticUpdateContract object itself.
     */
    public DiagnosticUpdateContract withOperationNameFormat(OperationNameFormat operationNameFormat) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiagnosticContractUpdateProperties();
        }
        this.innerProperties().withOperationNameFormat(operationNameFormat);
        return this;
    }

    /**
     * Get the metrics property: Emit custom metrics via emit-metric policy. Applicable only to Application Insights
     * diagnostic settings.
     * 
     * @return the metrics value.
     */
    public Boolean metrics() {
        return this.innerProperties() == null ? null : this.innerProperties().metrics();
    }

    /**
     * Set the metrics property: Emit custom metrics via emit-metric policy. Applicable only to Application Insights
     * diagnostic settings.
     * 
     * @param metrics the metrics value to set.
     * @return the DiagnosticUpdateContract object itself.
     */
    public DiagnosticUpdateContract withMetrics(Boolean metrics) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiagnosticContractUpdateProperties();
        }
        this.innerProperties().withMetrics(metrics);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DiagnosticUpdateContract from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DiagnosticUpdateContract if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DiagnosticUpdateContract.
     */
    public static DiagnosticUpdateContract fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DiagnosticUpdateContract deserializedDiagnosticUpdateContract = new DiagnosticUpdateContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedDiagnosticUpdateContract.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedDiagnosticUpdateContract.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedDiagnosticUpdateContract.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedDiagnosticUpdateContract.innerProperties
                        = DiagnosticContractUpdateProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDiagnosticUpdateContract;
        });
    }
}
