// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Email Template Parameter contract.
 */
@Fluent
public final class EmailTemplateParametersContractProperties
    implements JsonSerializable<EmailTemplateParametersContractProperties> {
    /*
     * Template parameter name.
     */
    private String name;

    /*
     * Template parameter title.
     */
    private String title;

    /*
     * Template parameter description.
     */
    private String description;

    /**
     * Creates an instance of EmailTemplateParametersContractProperties class.
     */
    public EmailTemplateParametersContractProperties() {
    }

    /**
     * Get the name property: Template parameter name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Template parameter name.
     * 
     * @param name the name value to set.
     * @return the EmailTemplateParametersContractProperties object itself.
     */
    public EmailTemplateParametersContractProperties withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the title property: Template parameter title.
     * 
     * @return the title value.
     */
    public String title() {
        return this.title;
    }

    /**
     * Set the title property: Template parameter title.
     * 
     * @param title the title value to set.
     * @return the EmailTemplateParametersContractProperties object itself.
     */
    public EmailTemplateParametersContractProperties withTitle(String title) {
        this.title = title;
        return this;
    }

    /**
     * Get the description property: Template parameter description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Template parameter description.
     * 
     * @param description the description value to set.
     * @return the EmailTemplateParametersContractProperties object itself.
     */
    public EmailTemplateParametersContractProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EmailTemplateParametersContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EmailTemplateParametersContractProperties if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the EmailTemplateParametersContractProperties.
     */
    public static EmailTemplateParametersContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EmailTemplateParametersContractProperties deserializedEmailTemplateParametersContractProperties
                = new EmailTemplateParametersContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedEmailTemplateParametersContractProperties.name = reader.getString();
                } else if ("title".equals(fieldName)) {
                    deserializedEmailTemplateParametersContractProperties.title = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedEmailTemplateParametersContractProperties.description = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEmailTemplateParametersContractProperties;
        });
    }
}
