// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Error Field contract.
 */
@Fluent
public final class ErrorFieldContract implements JsonSerializable<ErrorFieldContract> {
    /*
     * Property level error code.
     */
    private String code;

    /*
     * Human-readable representation of property-level error.
     */
    private String message;

    /*
     * Property name.
     */
    private String target;

    /**
     * Creates an instance of ErrorFieldContract class.
     */
    public ErrorFieldContract() {
    }

    /**
     * Get the code property: Property level error code.
     * 
     * @return the code value.
     */
    public String code() {
        return this.code;
    }

    /**
     * Set the code property: Property level error code.
     * 
     * @param code the code value to set.
     * @return the ErrorFieldContract object itself.
     */
    public ErrorFieldContract withCode(String code) {
        this.code = code;
        return this;
    }

    /**
     * Get the message property: Human-readable representation of property-level error.
     * 
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Set the message property: Human-readable representation of property-level error.
     * 
     * @param message the message value to set.
     * @return the ErrorFieldContract object itself.
     */
    public ErrorFieldContract withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get the target property: Property name.
     * 
     * @return the target value.
     */
    public String target() {
        return this.target;
    }

    /**
     * Set the target property: Property name.
     * 
     * @param target the target value to set.
     * @return the ErrorFieldContract object itself.
     */
    public ErrorFieldContract withTarget(String target) {
        this.target = target;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("target", this.target);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ErrorFieldContract from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ErrorFieldContract if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ErrorFieldContract.
     */
    public static ErrorFieldContract fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ErrorFieldContract deserializedErrorFieldContract = new ErrorFieldContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("code".equals(fieldName)) {
                    deserializedErrorFieldContract.code = reader.getString();
                } else if ("message".equals(fieldName)) {
                    deserializedErrorFieldContract.message = reader.getString();
                } else if ("target".equals(fieldName)) {
                    deserializedErrorFieldContract.target = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedErrorFieldContract;
        });
    }
}
