// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Error Body contract.
 */
@Fluent
public final class ErrorResponseBody implements JsonSerializable<ErrorResponseBody> {
    /*
     * Service-defined error code. This code serves as a sub-status for the HTTP error code specified in the response.
     */
    private String code;

    /*
     * Human-readable representation of the error.
     */
    private String message;

    /*
     * The list of invalid fields send in request, in case of validation error.
     */
    private List<ErrorFieldContract> details;

    /**
     * Creates an instance of ErrorResponseBody class.
     */
    public ErrorResponseBody() {
    }

    /**
     * Get the code property: Service-defined error code. This code serves as a sub-status for the HTTP error code
     * specified in the response.
     * 
     * @return the code value.
     */
    public String code() {
        return this.code;
    }

    /**
     * Set the code property: Service-defined error code. This code serves as a sub-status for the HTTP error code
     * specified in the response.
     * 
     * @param code the code value to set.
     * @return the ErrorResponseBody object itself.
     */
    public ErrorResponseBody withCode(String code) {
        this.code = code;
        return this;
    }

    /**
     * Get the message property: Human-readable representation of the error.
     * 
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Set the message property: Human-readable representation of the error.
     * 
     * @param message the message value to set.
     * @return the ErrorResponseBody object itself.
     */
    public ErrorResponseBody withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get the details property: The list of invalid fields send in request, in case of validation error.
     * 
     * @return the details value.
     */
    public List<ErrorFieldContract> details() {
        return this.details;
    }

    /**
     * Set the details property: The list of invalid fields send in request, in case of validation error.
     * 
     * @param details the details value to set.
     * @return the ErrorResponseBody object itself.
     */
    public ErrorResponseBody withDetails(List<ErrorFieldContract> details) {
        this.details = details;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (details() != null) {
            details().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ErrorResponseBody from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ErrorResponseBody if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ErrorResponseBody.
     */
    public static ErrorResponseBody fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ErrorResponseBody deserializedErrorResponseBody = new ErrorResponseBody();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("code".equals(fieldName)) {
                    deserializedErrorResponseBody.code = reader.getString();
                } else if ("message".equals(fieldName)) {
                    deserializedErrorResponseBody.message = reader.getString();
                } else if ("details".equals(fieldName)) {
                    List<ErrorFieldContract> details
                        = reader.readArray(reader1 -> ErrorFieldContract.fromJson(reader1));
                    deserializedErrorResponseBody.details = details;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedErrorResponseBody;
        });
    }
}
