// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Information regarding how the gateway should be exposed.
 */
@Immutable
public final class FrontendConfiguration implements JsonSerializable<FrontendConfiguration> {
    /*
     * The default hostname of the data-plane gateway to which requests can be sent. This is only applicable for API
     * gateway with Standard SKU.
     */
    private String defaultHostname;

    /**
     * Creates an instance of FrontendConfiguration class.
     */
    public FrontendConfiguration() {
    }

    /**
     * Get the defaultHostname property: The default hostname of the data-plane gateway to which requests can be sent.
     * This is only applicable for API gateway with Standard SKU.
     * 
     * @return the defaultHostname value.
     */
    public String defaultHostname() {
        return this.defaultHostname;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FrontendConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FrontendConfiguration if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FrontendConfiguration.
     */
    public static FrontendConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FrontendConfiguration deserializedFrontendConfiguration = new FrontendConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("defaultHostname".equals(fieldName)) {
                    deserializedFrontendConfiguration.defaultHostname = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFrontendConfiguration;
        });
    }
}
