// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Information regarding the Configuration API of the API Management gateway. This is only applicable for API gateway
 * with Standard SKU.
 */
@Immutable
public final class GatewayConfigurationApi implements JsonSerializable<GatewayConfigurationApi> {
    /*
     * Hostname to which the agent connects to propagate configuration to the cloud.
     */
    private String hostname;

    /**
     * Creates an instance of GatewayConfigurationApi class.
     */
    public GatewayConfigurationApi() {
    }

    /**
     * Get the hostname property: Hostname to which the agent connects to propagate configuration to the cloud.
     * 
     * @return the hostname value.
     */
    public String hostname() {
        return this.hostname;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GatewayConfigurationApi from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GatewayConfigurationApi if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GatewayConfigurationApi.
     */
    public static GatewayConfigurationApi fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GatewayConfigurationApi deserializedGatewayConfigurationApi = new GatewayConfigurationApi();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("hostname".equals(fieldName)) {
                    deserializedGatewayConfigurationApi.hostname = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGatewayConfigurationApi;
        });
    }
}
