// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.GatewayContractInner;
import java.util.Map;

/**
 * An immutable client-side representation of GatewayContract.
 */
public interface GatewayContract {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the locationData property: Gateway location.
     * 
     * @return the locationData value.
     */
    ResourceLocationDataContract locationData();

    /**
     * Gets the description property: Gateway description.
     * 
     * @return the description value.
     */
    String description();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.apimanagement.fluent.models.GatewayContractInner object.
     * 
     * @return the inner object.
     */
    GatewayContractInner innerModel();

    /**
     * The entirety of the GatewayContract definition.
     */
    interface Definition
        extends DefinitionStages.Blank, DefinitionStages.WithParentResource, DefinitionStages.WithCreate {
    }

    /**
     * The GatewayContract definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the GatewayContract definition.
         */
        interface Blank extends WithParentResource {
        }

        /**
         * The stage of the GatewayContract definition allowing to specify parent resource.
         */
        interface WithParentResource {
            /**
             * Specifies resourceGroupName, serviceName.
             * 
             * @param resourceGroupName The name of the resource group. The name is case insensitive.
             * @param serviceName The name of the API Management service.
             * @return the next definition stage.
             */
            WithCreate withExistingService(String resourceGroupName, String serviceName);
        }

        /**
         * The stage of the GatewayContract definition which contains all the minimum required properties for the
         * resource to be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate
            extends DefinitionStages.WithLocationData, DefinitionStages.WithDescription, DefinitionStages.WithIfMatch {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            GatewayContract create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            GatewayContract create(Context context);
        }

        /**
         * The stage of the GatewayContract definition allowing to specify locationData.
         */
        interface WithLocationData {
            /**
             * Specifies the locationData property: Gateway location..
             * 
             * @param locationData Gateway location.
             * @return the next definition stage.
             */
            WithCreate withLocationData(ResourceLocationDataContract locationData);
        }

        /**
         * The stage of the GatewayContract definition allowing to specify description.
         */
        interface WithDescription {
            /**
             * Specifies the description property: Gateway description.
             * 
             * @param description Gateway description.
             * @return the next definition stage.
             */
            WithCreate withDescription(String description);
        }

        /**
         * The stage of the GatewayContract definition allowing to specify ifMatch.
         */
        interface WithIfMatch {
            /**
             * Specifies the ifMatch property: ETag of the Entity. Not required when creating an entity, but required
             * when updating an entity..
             * 
             * @param ifMatch ETag of the Entity. Not required when creating an entity, but required when updating an
             * entity.
             * @return the next definition stage.
             */
            WithCreate withIfMatch(String ifMatch);
        }
    }

    /**
     * Begins update for the GatewayContract resource.
     * 
     * @return the stage of resource update.
     */
    GatewayContract.Update update();

    /**
     * The template for GatewayContract update.
     */
    interface Update extends UpdateStages.WithLocationData, UpdateStages.WithDescription, UpdateStages.WithIfMatch {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        GatewayContract apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        GatewayContract apply(Context context);
    }

    /**
     * The GatewayContract update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the GatewayContract update allowing to specify locationData.
         */
        interface WithLocationData {
            /**
             * Specifies the locationData property: Gateway location..
             * 
             * @param locationData Gateway location.
             * @return the next definition stage.
             */
            Update withLocationData(ResourceLocationDataContract locationData);
        }

        /**
         * The stage of the GatewayContract update allowing to specify description.
         */
        interface WithDescription {
            /**
             * Specifies the description property: Gateway description.
             * 
             * @param description Gateway description.
             * @return the next definition stage.
             */
            Update withDescription(String description);
        }

        /**
         * The stage of the GatewayContract update allowing to specify ifMatch.
         */
        interface WithIfMatch {
            /**
             * Specifies the ifMatch property: ETag of the Entity. ETag should match the current entity state from the
             * header response of the GET request or it should be * for unconditional update..
             * 
             * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of
             * the GET request or it should be * for unconditional update.
             * @return the next definition stage.
             */
            Update withIfMatch(String ifMatch);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    GatewayContract refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    GatewayContract refresh(Context context);

    /**
     * Retrieves gateway keys.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return gateway authentication keys.
     */
    Response<GatewayKeysContract> listKeysWithResponse(Context context);

    /**
     * Retrieves gateway keys.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return gateway authentication keys.
     */
    GatewayKeysContract listKeys();

    /**
     * Regenerates specified gateway key invalidating any tokens created with it.
     * 
     * @param parameters The parameters parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> regenerateKeyWithResponse(GatewayKeyRegenerationRequestContract parameters, Context context);

    /**
     * Regenerates specified gateway key invalidating any tokens created with it.
     * 
     * @param parameters The parameters parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void regenerateKey(GatewayKeyRegenerationRequestContract parameters);

    /**
     * Gets the Shared Access Authorization Token for the gateway.
     * 
     * @param parameters The parameters parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Shared Access Authorization Token for the gateway along with {@link Response}.
     */
    Response<GatewayTokenContract> generateTokenWithResponse(GatewayTokenRequestContract parameters, Context context);

    /**
     * Gets the Shared Access Authorization Token for the gateway.
     * 
     * @param parameters The parameters parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Shared Access Authorization Token for the gateway.
     */
    GatewayTokenContract generateToken(GatewayTokenRequestContract parameters);

    /**
     * Action is invalidating all debug credentials issued for gateway.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> invalidateDebugCredentialsWithResponse(Context context);

    /**
     * Action is invalidating all debug credentials issued for gateway.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void invalidateDebugCredentials();

    /**
     * Create new debug credentials for gateway.
     * 
     * @param parameters List debug credentials properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return gateway debug credentials along with {@link Response}.
     */
    Response<GatewayDebugCredentialsContract>
        listDebugCredentialsWithResponse(GatewayListDebugCredentialsContract parameters, Context context);

    /**
     * Create new debug credentials for gateway.
     * 
     * @param parameters List debug credentials properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return gateway debug credentials.
     */
    GatewayDebugCredentialsContract listDebugCredentials(GatewayListDebugCredentialsContract parameters);

    /**
     * Fetches trace collected by gateway.
     * 
     * @param parameters List trace properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return trace collected in gateway along with {@link Response}.
     */
    Response<Map<String, Object>> listTraceWithResponse(GatewayListTraceContract parameters, Context context);

    /**
     * Fetches trace collected by gateway.
     * 
     * @param parameters List trace properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return trace collected in gateway.
     */
    Map<String, Object> listTrace(GatewayListTraceContract parameters);
}
