// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Gateway key regeneration request contract properties.
 */
@Fluent
public final class GatewayKeyRegenerationRequestContract
    implements JsonSerializable<GatewayKeyRegenerationRequestContract> {
    /*
     * The Key being regenerated.
     */
    private KeyType keyType;

    /**
     * Creates an instance of GatewayKeyRegenerationRequestContract class.
     */
    public GatewayKeyRegenerationRequestContract() {
    }

    /**
     * Get the keyType property: The Key being regenerated.
     * 
     * @return the keyType value.
     */
    public KeyType keyType() {
        return this.keyType;
    }

    /**
     * Set the keyType property: The Key being regenerated.
     * 
     * @param keyType the keyType value to set.
     * @return the GatewayKeyRegenerationRequestContract object itself.
     */
    public GatewayKeyRegenerationRequestContract withKeyType(KeyType keyType) {
        this.keyType = keyType;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (keyType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property keyType in model GatewayKeyRegenerationRequestContract"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GatewayKeyRegenerationRequestContract.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyType", this.keyType == null ? null : this.keyType.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GatewayKeyRegenerationRequestContract from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GatewayKeyRegenerationRequestContract if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GatewayKeyRegenerationRequestContract.
     */
    public static GatewayKeyRegenerationRequestContract fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GatewayKeyRegenerationRequestContract deserializedGatewayKeyRegenerationRequestContract
                = new GatewayKeyRegenerationRequestContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("keyType".equals(fieldName)) {
                    deserializedGatewayKeyRegenerationRequestContract.keyType = KeyType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGatewayKeyRegenerationRequestContract;
        });
    }
}
