// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

/**
 * List debug credentials properties.
 */
@Fluent
public final class GatewayListDebugCredentialsContract
    implements JsonSerializable<GatewayListDebugCredentialsContract> {
    /*
     * Credentials expiration in ISO8601 format. Maximum duration of the credentials is PT1H. When property is not
     * specified, them value PT1H is used.
     */
    private Duration credentialsExpireAfter;

    /*
     * Purposes of debug credential.
     */
    private List<GatewayListDebugCredentialsContractPurpose> purposes;

    /*
     * Full resource Id of an API.
     */
    private String apiId;

    /**
     * Creates an instance of GatewayListDebugCredentialsContract class.
     */
    public GatewayListDebugCredentialsContract() {
    }

    /**
     * Get the credentialsExpireAfter property: Credentials expiration in ISO8601 format. Maximum duration of the
     * credentials is PT1H. When property is not specified, them value PT1H is used.
     * 
     * @return the credentialsExpireAfter value.
     */
    public Duration credentialsExpireAfter() {
        return this.credentialsExpireAfter;
    }

    /**
     * Set the credentialsExpireAfter property: Credentials expiration in ISO8601 format. Maximum duration of the
     * credentials is PT1H. When property is not specified, them value PT1H is used.
     * 
     * @param credentialsExpireAfter the credentialsExpireAfter value to set.
     * @return the GatewayListDebugCredentialsContract object itself.
     */
    public GatewayListDebugCredentialsContract withCredentialsExpireAfter(Duration credentialsExpireAfter) {
        this.credentialsExpireAfter = credentialsExpireAfter;
        return this;
    }

    /**
     * Get the purposes property: Purposes of debug credential.
     * 
     * @return the purposes value.
     */
    public List<GatewayListDebugCredentialsContractPurpose> purposes() {
        return this.purposes;
    }

    /**
     * Set the purposes property: Purposes of debug credential.
     * 
     * @param purposes the purposes value to set.
     * @return the GatewayListDebugCredentialsContract object itself.
     */
    public GatewayListDebugCredentialsContract withPurposes(List<GatewayListDebugCredentialsContractPurpose> purposes) {
        this.purposes = purposes;
        return this;
    }

    /**
     * Get the apiId property: Full resource Id of an API.
     * 
     * @return the apiId value.
     */
    public String apiId() {
        return this.apiId;
    }

    /**
     * Set the apiId property: Full resource Id of an API.
     * 
     * @param apiId the apiId value to set.
     * @return the GatewayListDebugCredentialsContract object itself.
     */
    public GatewayListDebugCredentialsContract withApiId(String apiId) {
        this.apiId = apiId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (purposes() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property purposes in model GatewayListDebugCredentialsContract"));
        }
        if (apiId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property apiId in model GatewayListDebugCredentialsContract"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GatewayListDebugCredentialsContract.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("purposes", this.purposes,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("apiId", this.apiId);
        jsonWriter.writeStringField("credentialsExpireAfter",
            CoreUtils.durationToStringWithDays(this.credentialsExpireAfter));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GatewayListDebugCredentialsContract from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GatewayListDebugCredentialsContract if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GatewayListDebugCredentialsContract.
     */
    public static GatewayListDebugCredentialsContract fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GatewayListDebugCredentialsContract deserializedGatewayListDebugCredentialsContract
                = new GatewayListDebugCredentialsContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("purposes".equals(fieldName)) {
                    List<GatewayListDebugCredentialsContractPurpose> purposes = reader.readArray(
                        reader1 -> GatewayListDebugCredentialsContractPurpose.fromString(reader1.getString()));
                    deserializedGatewayListDebugCredentialsContract.purposes = purposes;
                } else if ("apiId".equals(fieldName)) {
                    deserializedGatewayListDebugCredentialsContract.apiId = reader.getString();
                } else if ("credentialsExpireAfter".equals(fieldName)) {
                    deserializedGatewayListDebugCredentialsContract.credentialsExpireAfter
                        = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGatewayListDebugCredentialsContract;
        });
    }
}
