// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * List trace properties.
 */
@Fluent
public final class GatewayListTraceContract implements JsonSerializable<GatewayListTraceContract> {
    /*
     * Trace id.
     */
    private String traceId;

    /**
     * Creates an instance of GatewayListTraceContract class.
     */
    public GatewayListTraceContract() {
    }

    /**
     * Get the traceId property: Trace id.
     * 
     * @return the traceId value.
     */
    public String traceId() {
        return this.traceId;
    }

    /**
     * Set the traceId property: Trace id.
     * 
     * @param traceId the traceId value to set.
     * @return the GatewayListTraceContract object itself.
     */
    public GatewayListTraceContract withTraceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("traceId", this.traceId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GatewayListTraceContract from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GatewayListTraceContract if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GatewayListTraceContract.
     */
    public static GatewayListTraceContract fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GatewayListTraceContract deserializedGatewayListTraceContract = new GatewayListTraceContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("traceId".equals(fieldName)) {
                    deserializedGatewayListTraceContract.traceId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGatewayListTraceContract;
        });
    }
}
