// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.GatewayResourceSkuResultInner;
import java.io.IOException;
import java.util.List;

/**
 * The API Management gateway SKUs operation response.
 */
@Fluent
public final class GatewayResourceSkuResults implements JsonSerializable<GatewayResourceSkuResults> {
    /*
     * The list of skus available for the gateway.
     */
    private List<GatewayResourceSkuResultInner> value;

    /*
     * The uri to fetch the next page of API Management gateway Skus.
     */
    private String nextLink;

    /**
     * Creates an instance of GatewayResourceSkuResults class.
     */
    public GatewayResourceSkuResults() {
    }

    /**
     * Get the value property: The list of skus available for the gateway.
     * 
     * @return the value value.
     */
    public List<GatewayResourceSkuResultInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of skus available for the gateway.
     * 
     * @param value the value value to set.
     * @return the GatewayResourceSkuResults object itself.
     */
    public GatewayResourceSkuResults withValue(List<GatewayResourceSkuResultInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The uri to fetch the next page of API Management gateway Skus.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The uri to fetch the next page of API Management gateway Skus.
     * 
     * @param nextLink the nextLink value to set.
     * @return the GatewayResourceSkuResults object itself.
     */
    public GatewayResourceSkuResults withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property value in model GatewayResourceSkuResults"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GatewayResourceSkuResults.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GatewayResourceSkuResults from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GatewayResourceSkuResults if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GatewayResourceSkuResults.
     */
    public static GatewayResourceSkuResults fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GatewayResourceSkuResults deserializedGatewayResourceSkuResults = new GatewayResourceSkuResults();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<GatewayResourceSkuResultInner> value
                        = reader.readArray(reader1 -> GatewayResourceSkuResultInner.fromJson(reader1));
                    deserializedGatewayResourceSkuResults.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedGatewayResourceSkuResults.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGatewayResourceSkuResults;
        });
    }
}
