// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes an available API Management SKU for gateways.
 */
@Fluent
public final class GatewaySku implements JsonSerializable<GatewaySku> {
    /*
     * Name of the Sku.
     */
    private ApiGatewaySkuType name;

    /**
     * Creates an instance of GatewaySku class.
     */
    public GatewaySku() {
    }

    /**
     * Get the name property: Name of the Sku.
     * 
     * @return the name value.
     */
    public ApiGatewaySkuType name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the Sku.
     * 
     * @param name the name value to set.
     * @return the GatewaySku object itself.
     */
    public GatewaySku withName(ApiGatewaySkuType name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GatewaySku from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GatewaySku if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the GatewaySku.
     */
    public static GatewaySku fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GatewaySku deserializedGatewaySku = new GatewaySku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedGatewaySku.name = ApiGatewaySkuType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGatewaySku;
        });
    }
}
