// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.GlobalSchemaContractInner;

/**
 * An immutable client-side representation of GlobalSchemaContract.
 */
public interface GlobalSchemaContract {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the schemaType property: Schema Type. Immutable.
     * 
     * @return the schemaType value.
     */
    SchemaType schemaType();

    /**
     * Gets the description property: Free-form schema entity description.
     * 
     * @return the description value.
     */
    String description();

    /**
     * Gets the value property: Json-encoded string for non json-based schema.
     * 
     * @return the value value.
     */
    Object value();

    /**
     * Gets the document property: Global Schema document object for json-based schema formats(e.g. json schema).
     * 
     * @return the document value.
     */
    Object document();

    /**
     * Gets the provisioningState property: The provisioning state.
     * 
     * @return the provisioningState value.
     */
    String provisioningState();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.apimanagement.fluent.models.GlobalSchemaContractInner object.
     * 
     * @return the inner object.
     */
    GlobalSchemaContractInner innerModel();

    /**
     * The entirety of the GlobalSchemaContract definition.
     */
    interface Definition
        extends DefinitionStages.Blank, DefinitionStages.WithParentResource, DefinitionStages.WithCreate {
    }

    /**
     * The GlobalSchemaContract definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the GlobalSchemaContract definition.
         */
        interface Blank extends WithParentResource {
        }

        /**
         * The stage of the GlobalSchemaContract definition allowing to specify parent resource.
         */
        interface WithParentResource {
            /**
             * Specifies resourceGroupName, serviceName.
             * 
             * @param resourceGroupName The name of the resource group. The name is case insensitive.
             * @param serviceName The name of the API Management service.
             * @return the next definition stage.
             */
            WithCreate withExistingService(String resourceGroupName, String serviceName);
        }

        /**
         * The stage of the GlobalSchemaContract definition which contains all the minimum required properties for the
         * resource to be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate extends DefinitionStages.WithSchemaType, DefinitionStages.WithDescription,
            DefinitionStages.WithValue, DefinitionStages.WithDocument, DefinitionStages.WithIfMatch {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            GlobalSchemaContract create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            GlobalSchemaContract create(Context context);
        }

        /**
         * The stage of the GlobalSchemaContract definition allowing to specify schemaType.
         */
        interface WithSchemaType {
            /**
             * Specifies the schemaType property: Schema Type. Immutable..
             * 
             * @param schemaType Schema Type. Immutable.
             * @return the next definition stage.
             */
            WithCreate withSchemaType(SchemaType schemaType);
        }

        /**
         * The stage of the GlobalSchemaContract definition allowing to specify description.
         */
        interface WithDescription {
            /**
             * Specifies the description property: Free-form schema entity description..
             * 
             * @param description Free-form schema entity description.
             * @return the next definition stage.
             */
            WithCreate withDescription(String description);
        }

        /**
         * The stage of the GlobalSchemaContract definition allowing to specify value.
         */
        interface WithValue {
            /**
             * Specifies the value property: Json-encoded string for non json-based schema..
             * 
             * @param value Json-encoded string for non json-based schema.
             * @return the next definition stage.
             */
            WithCreate withValue(Object value);
        }

        /**
         * The stage of the GlobalSchemaContract definition allowing to specify document.
         */
        interface WithDocument {
            /**
             * Specifies the document property: Global Schema document object for json-based schema formats(e.g. json
             * schema)..
             * 
             * @param document Global Schema document object for json-based schema formats(e.g. json schema).
             * @return the next definition stage.
             */
            WithCreate withDocument(Object document);
        }

        /**
         * The stage of the GlobalSchemaContract definition allowing to specify ifMatch.
         */
        interface WithIfMatch {
            /**
             * Specifies the ifMatch property: ETag of the Entity. Not required when creating an entity, but required
             * when updating an entity..
             * 
             * @param ifMatch ETag of the Entity. Not required when creating an entity, but required when updating an
             * entity.
             * @return the next definition stage.
             */
            WithCreate withIfMatch(String ifMatch);
        }
    }

    /**
     * Begins update for the GlobalSchemaContract resource.
     * 
     * @return the stage of resource update.
     */
    GlobalSchemaContract.Update update();

    /**
     * The template for GlobalSchemaContract update.
     */
    interface Update extends UpdateStages.WithSchemaType, UpdateStages.WithDescription, UpdateStages.WithValue,
        UpdateStages.WithDocument, UpdateStages.WithIfMatch {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        GlobalSchemaContract apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        GlobalSchemaContract apply(Context context);
    }

    /**
     * The GlobalSchemaContract update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the GlobalSchemaContract update allowing to specify schemaType.
         */
        interface WithSchemaType {
            /**
             * Specifies the schemaType property: Schema Type. Immutable..
             * 
             * @param schemaType Schema Type. Immutable.
             * @return the next definition stage.
             */
            Update withSchemaType(SchemaType schemaType);
        }

        /**
         * The stage of the GlobalSchemaContract update allowing to specify description.
         */
        interface WithDescription {
            /**
             * Specifies the description property: Free-form schema entity description..
             * 
             * @param description Free-form schema entity description.
             * @return the next definition stage.
             */
            Update withDescription(String description);
        }

        /**
         * The stage of the GlobalSchemaContract update allowing to specify value.
         */
        interface WithValue {
            /**
             * Specifies the value property: Json-encoded string for non json-based schema..
             * 
             * @param value Json-encoded string for non json-based schema.
             * @return the next definition stage.
             */
            Update withValue(Object value);
        }

        /**
         * The stage of the GlobalSchemaContract update allowing to specify document.
         */
        interface WithDocument {
            /**
             * Specifies the document property: Global Schema document object for json-based schema formats(e.g. json
             * schema)..
             * 
             * @param document Global Schema document object for json-based schema formats(e.g. json schema).
             * @return the next definition stage.
             */
            Update withDocument(Object document);
        }

        /**
         * The stage of the GlobalSchemaContract update allowing to specify ifMatch.
         */
        interface WithIfMatch {
            /**
             * Specifies the ifMatch property: ETag of the Entity. Not required when creating an entity, but required
             * when updating an entity..
             * 
             * @param ifMatch ETag of the Entity. Not required when creating an entity, but required when updating an
             * entity.
             * @return the next definition stage.
             */
            Update withIfMatch(String ifMatch);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    GlobalSchemaContract refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    GlobalSchemaContract refresh(Context context);
}
