// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Defines values for GrantType.
 */
public final class GrantType extends ExpandableStringEnum<GrantType> {
    /**
     * Static value authorizationCode for GrantType.
     */
    public static final GrantType AUTHORIZATION_CODE = fromString("authorizationCode");

    /**
     * Static value implicit for GrantType.
     */
    public static final GrantType IMPLICIT = fromString("implicit");

    /**
     * Static value resourceOwnerPassword for GrantType.
     */
    public static final GrantType RESOURCE_OWNER_PASSWORD = fromString("resourceOwnerPassword");

    /**
     * Static value clientCredentials for GrantType.
     */
    public static final GrantType CLIENT_CREDENTIALS = fromString("clientCredentials");

    /**
     * Creates a new instance of GrantType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public GrantType() {
    }

    /**
     * Creates or finds a GrantType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding GrantType.
     */
    public static GrantType fromString(String name) {
        return fromString(name, GrantType.class);
    }

    /**
     * Gets known GrantType values.
     * 
     * @return known GrantType values.
     */
    public static Collection<GrantType> values() {
        return values(GrantType.class);
    }
}
