// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

/**
 * Group type.
 */
public enum GroupType {
    /**
     * Enum value custom.
     */
    CUSTOM("custom"),

    /**
     * Enum value system.
     */
    SYSTEM("system"),

    /**
     * Enum value external.
     */
    EXTERNAL("external");

    /**
     * The actual serialized value for a GroupType instance.
     */
    private final String value;

    GroupType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a GroupType instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed GroupType object, or null if unable to parse.
     */
    public static GroupType fromString(String value) {
        if (value == null) {
            return null;
        }
        GroupType[] items = GroupType.values();
        for (GroupType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
