// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.GroupUpdateParametersProperties;
import java.io.IOException;

/**
 * Parameters supplied to the Update Group operation.
 */
@Fluent
public final class GroupUpdateParameters implements JsonSerializable<GroupUpdateParameters> {
    /*
     * Group entity update contract properties.
     */
    private GroupUpdateParametersProperties innerProperties;

    /**
     * Creates an instance of GroupUpdateParameters class.
     */
    public GroupUpdateParameters() {
    }

    /**
     * Get the innerProperties property: Group entity update contract properties.
     * 
     * @return the innerProperties value.
     */
    private GroupUpdateParametersProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the displayName property: Group name.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    /**
     * Set the displayName property: Group name.
     * 
     * @param displayName the displayName value to set.
     * @return the GroupUpdateParameters object itself.
     */
    public GroupUpdateParameters withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GroupUpdateParametersProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    /**
     * Get the description property: Group description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: Group description.
     * 
     * @param description the description value to set.
     * @return the GroupUpdateParameters object itself.
     */
    public GroupUpdateParameters withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GroupUpdateParametersProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the type property: Group type.
     * 
     * @return the type value.
     */
    public GroupType type() {
        return this.innerProperties() == null ? null : this.innerProperties().type();
    }

    /**
     * Set the type property: Group type.
     * 
     * @param type the type value to set.
     * @return the GroupUpdateParameters object itself.
     */
    public GroupUpdateParameters withType(GroupType type) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GroupUpdateParametersProperties();
        }
        this.innerProperties().withType(type);
        return this;
    }

    /**
     * Get the externalId property: Identifier of the external groups, this property contains the id of the group from
     * the external identity provider, e.g. for Azure Active Directory
     * `aad://&lt;tenant&gt;.onmicrosoft.com/groups/&lt;group object id&gt;`; otherwise the value is null.
     * 
     * @return the externalId value.
     */
    public String externalId() {
        return this.innerProperties() == null ? null : this.innerProperties().externalId();
    }

    /**
     * Set the externalId property: Identifier of the external groups, this property contains the id of the group from
     * the external identity provider, e.g. for Azure Active Directory
     * `aad://&lt;tenant&gt;.onmicrosoft.com/groups/&lt;group object id&gt;`; otherwise the value is null.
     * 
     * @param externalId the externalId value to set.
     * @return the GroupUpdateParameters object itself.
     */
    public GroupUpdateParameters withExternalId(String externalId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GroupUpdateParametersProperties();
        }
        this.innerProperties().withExternalId(externalId);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GroupUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GroupUpdateParameters if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GroupUpdateParameters.
     */
    public static GroupUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GroupUpdateParameters deserializedGroupUpdateParameters = new GroupUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedGroupUpdateParameters.innerProperties
                        = GroupUpdateParametersProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGroupUpdateParameters;
        });
    }
}
