// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Custom hostname configuration.
 */
@Fluent
public final class HostnameConfiguration implements JsonSerializable<HostnameConfiguration> {
    /*
     * Hostname type.
     */
    private HostnameType type;

    /*
     * Hostname to configure on the Api Management service.
     */
    private String hostname;

    /*
     * Url to the KeyVault Secret containing the Ssl Certificate. If absolute Url containing version is provided,
     * auto-update of ssl certificate will not work. This requires Api Management service to be configured with
     * aka.ms/apimmsi. The secret should be of type *application/x-pkcs12*
     */
    private String keyVaultId;

    /*
     * System or User Assigned Managed identity clientId as generated by Azure AD, which has GET access to the keyVault
     * containing the SSL certificate.
     */
    private String identityClientId;

    /*
     * Base64 Encoded certificate.
     */
    private String encodedCertificate;

    /*
     * Certificate Password.
     */
    private String certificatePassword;

    /*
     * Specify true to setup the certificate associated with this Hostname as the Default SSL Certificate. If a client
     * does not send the SNI header, then this will be the certificate that will be challenged. The property is useful
     * if a service has multiple custom hostname enabled and it needs to decide on the default ssl certificate. The
     * setting only applied to gateway Hostname Type.
     */
    private Boolean defaultSslBinding;

    /*
     * Specify true to always negotiate client certificate on the hostname. Default Value is false.
     */
    private Boolean negotiateClientCertificate;

    /*
     * Certificate information.
     */
    private CertificateInformation certificate;

    /*
     * Certificate Source.
     */
    private CertificateSource certificateSource;

    /*
     * Certificate Status.
     */
    private CertificateStatus certificateStatus;

    /**
     * Creates an instance of HostnameConfiguration class.
     */
    public HostnameConfiguration() {
    }

    /**
     * Get the type property: Hostname type.
     * 
     * @return the type value.
     */
    public HostnameType type() {
        return this.type;
    }

    /**
     * Set the type property: Hostname type.
     * 
     * @param type the type value to set.
     * @return the HostnameConfiguration object itself.
     */
    public HostnameConfiguration withType(HostnameType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the hostname property: Hostname to configure on the Api Management service.
     * 
     * @return the hostname value.
     */
    public String hostname() {
        return this.hostname;
    }

    /**
     * Set the hostname property: Hostname to configure on the Api Management service.
     * 
     * @param hostname the hostname value to set.
     * @return the HostnameConfiguration object itself.
     */
    public HostnameConfiguration withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    /**
     * Get the keyVaultId property: Url to the KeyVault Secret containing the Ssl Certificate. If absolute Url
     * containing version is provided, auto-update of ssl certificate will not work. This requires Api Management
     * service to be configured with aka.ms/apimmsi. The secret should be of type *application/x-pkcs12*.
     * 
     * @return the keyVaultId value.
     */
    public String keyVaultId() {
        return this.keyVaultId;
    }

    /**
     * Set the keyVaultId property: Url to the KeyVault Secret containing the Ssl Certificate. If absolute Url
     * containing version is provided, auto-update of ssl certificate will not work. This requires Api Management
     * service to be configured with aka.ms/apimmsi. The secret should be of type *application/x-pkcs12*.
     * 
     * @param keyVaultId the keyVaultId value to set.
     * @return the HostnameConfiguration object itself.
     */
    public HostnameConfiguration withKeyVaultId(String keyVaultId) {
        this.keyVaultId = keyVaultId;
        return this;
    }

    /**
     * Get the identityClientId property: System or User Assigned Managed identity clientId as generated by Azure AD,
     * which has GET access to the keyVault containing the SSL certificate.
     * 
     * @return the identityClientId value.
     */
    public String identityClientId() {
        return this.identityClientId;
    }

    /**
     * Set the identityClientId property: System or User Assigned Managed identity clientId as generated by Azure AD,
     * which has GET access to the keyVault containing the SSL certificate.
     * 
     * @param identityClientId the identityClientId value to set.
     * @return the HostnameConfiguration object itself.
     */
    public HostnameConfiguration withIdentityClientId(String identityClientId) {
        this.identityClientId = identityClientId;
        return this;
    }

    /**
     * Get the encodedCertificate property: Base64 Encoded certificate.
     * 
     * @return the encodedCertificate value.
     */
    public String encodedCertificate() {
        return this.encodedCertificate;
    }

    /**
     * Set the encodedCertificate property: Base64 Encoded certificate.
     * 
     * @param encodedCertificate the encodedCertificate value to set.
     * @return the HostnameConfiguration object itself.
     */
    public HostnameConfiguration withEncodedCertificate(String encodedCertificate) {
        this.encodedCertificate = encodedCertificate;
        return this;
    }

    /**
     * Get the certificatePassword property: Certificate Password.
     * 
     * @return the certificatePassword value.
     */
    public String certificatePassword() {
        return this.certificatePassword;
    }

    /**
     * Set the certificatePassword property: Certificate Password.
     * 
     * @param certificatePassword the certificatePassword value to set.
     * @return the HostnameConfiguration object itself.
     */
    public HostnameConfiguration withCertificatePassword(String certificatePassword) {
        this.certificatePassword = certificatePassword;
        return this;
    }

    /**
     * Get the defaultSslBinding property: Specify true to setup the certificate associated with this Hostname as the
     * Default SSL Certificate. If a client does not send the SNI header, then this will be the certificate that will be
     * challenged. The property is useful if a service has multiple custom hostname enabled and it needs to decide on
     * the default ssl certificate. The setting only applied to gateway Hostname Type.
     * 
     * @return the defaultSslBinding value.
     */
    public Boolean defaultSslBinding() {
        return this.defaultSslBinding;
    }

    /**
     * Set the defaultSslBinding property: Specify true to setup the certificate associated with this Hostname as the
     * Default SSL Certificate. If a client does not send the SNI header, then this will be the certificate that will be
     * challenged. The property is useful if a service has multiple custom hostname enabled and it needs to decide on
     * the default ssl certificate. The setting only applied to gateway Hostname Type.
     * 
     * @param defaultSslBinding the defaultSslBinding value to set.
     * @return the HostnameConfiguration object itself.
     */
    public HostnameConfiguration withDefaultSslBinding(Boolean defaultSslBinding) {
        this.defaultSslBinding = defaultSslBinding;
        return this;
    }

    /**
     * Get the negotiateClientCertificate property: Specify true to always negotiate client certificate on the hostname.
     * Default Value is false.
     * 
     * @return the negotiateClientCertificate value.
     */
    public Boolean negotiateClientCertificate() {
        return this.negotiateClientCertificate;
    }

    /**
     * Set the negotiateClientCertificate property: Specify true to always negotiate client certificate on the hostname.
     * Default Value is false.
     * 
     * @param negotiateClientCertificate the negotiateClientCertificate value to set.
     * @return the HostnameConfiguration object itself.
     */
    public HostnameConfiguration withNegotiateClientCertificate(Boolean negotiateClientCertificate) {
        this.negotiateClientCertificate = negotiateClientCertificate;
        return this;
    }

    /**
     * Get the certificate property: Certificate information.
     * 
     * @return the certificate value.
     */
    public CertificateInformation certificate() {
        return this.certificate;
    }

    /**
     * Set the certificate property: Certificate information.
     * 
     * @param certificate the certificate value to set.
     * @return the HostnameConfiguration object itself.
     */
    public HostnameConfiguration withCertificate(CertificateInformation certificate) {
        this.certificate = certificate;
        return this;
    }

    /**
     * Get the certificateSource property: Certificate Source.
     * 
     * @return the certificateSource value.
     */
    public CertificateSource certificateSource() {
        return this.certificateSource;
    }

    /**
     * Set the certificateSource property: Certificate Source.
     * 
     * @param certificateSource the certificateSource value to set.
     * @return the HostnameConfiguration object itself.
     */
    public HostnameConfiguration withCertificateSource(CertificateSource certificateSource) {
        this.certificateSource = certificateSource;
        return this;
    }

    /**
     * Get the certificateStatus property: Certificate Status.
     * 
     * @return the certificateStatus value.
     */
    public CertificateStatus certificateStatus() {
        return this.certificateStatus;
    }

    /**
     * Set the certificateStatus property: Certificate Status.
     * 
     * @param certificateStatus the certificateStatus value to set.
     * @return the HostnameConfiguration object itself.
     */
    public HostnameConfiguration withCertificateStatus(CertificateStatus certificateStatus) {
        this.certificateStatus = certificateStatus;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (type() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property type in model HostnameConfiguration"));
        }
        if (hostname() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property hostname in model HostnameConfiguration"));
        }
        if (certificate() != null) {
            certificate().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(HostnameConfiguration.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("hostName", this.hostname);
        jsonWriter.writeStringField("keyVaultId", this.keyVaultId);
        jsonWriter.writeStringField("identityClientId", this.identityClientId);
        jsonWriter.writeStringField("encodedCertificate", this.encodedCertificate);
        jsonWriter.writeStringField("certificatePassword", this.certificatePassword);
        jsonWriter.writeBooleanField("defaultSslBinding", this.defaultSslBinding);
        jsonWriter.writeBooleanField("negotiateClientCertificate", this.negotiateClientCertificate);
        jsonWriter.writeJsonField("certificate", this.certificate);
        jsonWriter.writeStringField("certificateSource",
            this.certificateSource == null ? null : this.certificateSource.toString());
        jsonWriter.writeStringField("certificateStatus",
            this.certificateStatus == null ? null : this.certificateStatus.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HostnameConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HostnameConfiguration if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the HostnameConfiguration.
     */
    public static HostnameConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HostnameConfiguration deserializedHostnameConfiguration = new HostnameConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedHostnameConfiguration.type = HostnameType.fromString(reader.getString());
                } else if ("hostName".equals(fieldName)) {
                    deserializedHostnameConfiguration.hostname = reader.getString();
                } else if ("keyVaultId".equals(fieldName)) {
                    deserializedHostnameConfiguration.keyVaultId = reader.getString();
                } else if ("identityClientId".equals(fieldName)) {
                    deserializedHostnameConfiguration.identityClientId = reader.getString();
                } else if ("encodedCertificate".equals(fieldName)) {
                    deserializedHostnameConfiguration.encodedCertificate = reader.getString();
                } else if ("certificatePassword".equals(fieldName)) {
                    deserializedHostnameConfiguration.certificatePassword = reader.getString();
                } else if ("defaultSslBinding".equals(fieldName)) {
                    deserializedHostnameConfiguration.defaultSslBinding = reader.getNullable(JsonReader::getBoolean);
                } else if ("negotiateClientCertificate".equals(fieldName)) {
                    deserializedHostnameConfiguration.negotiateClientCertificate
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("certificate".equals(fieldName)) {
                    deserializedHostnameConfiguration.certificate = CertificateInformation.fromJson(reader);
                } else if ("certificateSource".equals(fieldName)) {
                    deserializedHostnameConfiguration.certificateSource
                        = CertificateSource.fromString(reader.getString());
                } else if ("certificateStatus".equals(fieldName)) {
                    deserializedHostnameConfiguration.certificateStatus
                        = CertificateStatus.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHostnameConfiguration;
        });
    }
}
