// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * HTTP header and it's value.
 */
@Fluent
public final class HttpHeader implements JsonSerializable<HttpHeader> {
    /*
     * Header name.
     */
    private String name;

    /*
     * Header value.
     */
    private String value;

    /**
     * Creates an instance of HttpHeader class.
     */
    public HttpHeader() {
    }

    /**
     * Get the name property: Header name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Header name.
     * 
     * @param name the name value to set.
     * @return the HttpHeader object itself.
     */
    public HttpHeader withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the value property: Header value.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: Header value.
     * 
     * @param value the value value to set.
     * @return the HttpHeader object itself.
     */
    public HttpHeader withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model HttpHeader"));
        }
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property value in model HttpHeader"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(HttpHeader.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HttpHeader from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HttpHeader if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the HttpHeader.
     */
    public static HttpHeader fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HttpHeader deserializedHttpHeader = new HttpHeader();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedHttpHeader.name = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedHttpHeader.value = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHttpHeader;
        });
    }
}
