// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Http message diagnostic settings.
 */
@Fluent
public final class HttpMessageDiagnostic implements JsonSerializable<HttpMessageDiagnostic> {
    /*
     * Array of HTTP Headers to log.
     */
    private List<String> headers;

    /*
     * Body logging settings.
     */
    private BodyDiagnosticSettings body;

    /*
     * Data masking settings.
     */
    private DataMasking dataMasking;

    /**
     * Creates an instance of HttpMessageDiagnostic class.
     */
    public HttpMessageDiagnostic() {
    }

    /**
     * Get the headers property: Array of HTTP Headers to log.
     * 
     * @return the headers value.
     */
    public List<String> headers() {
        return this.headers;
    }

    /**
     * Set the headers property: Array of HTTP Headers to log.
     * 
     * @param headers the headers value to set.
     * @return the HttpMessageDiagnostic object itself.
     */
    public HttpMessageDiagnostic withHeaders(List<String> headers) {
        this.headers = headers;
        return this;
    }

    /**
     * Get the body property: Body logging settings.
     * 
     * @return the body value.
     */
    public BodyDiagnosticSettings body() {
        return this.body;
    }

    /**
     * Set the body property: Body logging settings.
     * 
     * @param body the body value to set.
     * @return the HttpMessageDiagnostic object itself.
     */
    public HttpMessageDiagnostic withBody(BodyDiagnosticSettings body) {
        this.body = body;
        return this;
    }

    /**
     * Get the dataMasking property: Data masking settings.
     * 
     * @return the dataMasking value.
     */
    public DataMasking dataMasking() {
        return this.dataMasking;
    }

    /**
     * Set the dataMasking property: Data masking settings.
     * 
     * @param dataMasking the dataMasking value to set.
     * @return the HttpMessageDiagnostic object itself.
     */
    public HttpMessageDiagnostic withDataMasking(DataMasking dataMasking) {
        this.dataMasking = dataMasking;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (body() != null) {
            body().validate();
        }
        if (dataMasking() != null) {
            dataMasking().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("headers", this.headers, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("body", this.body);
        jsonWriter.writeJsonField("dataMasking", this.dataMasking);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HttpMessageDiagnostic from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HttpMessageDiagnostic if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the HttpMessageDiagnostic.
     */
    public static HttpMessageDiagnostic fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HttpMessageDiagnostic deserializedHttpMessageDiagnostic = new HttpMessageDiagnostic();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("headers".equals(fieldName)) {
                    List<String> headers = reader.readArray(reader1 -> reader1.getString());
                    deserializedHttpMessageDiagnostic.headers = headers;
                } else if ("body".equals(fieldName)) {
                    deserializedHttpMessageDiagnostic.body = BodyDiagnosticSettings.fromJson(reader);
                } else if ("dataMasking".equals(fieldName)) {
                    deserializedHttpMessageDiagnostic.dataMasking = DataMasking.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHttpMessageDiagnostic;
        });
    }
}
