// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.IdentityProviderUpdateProperties;
import java.io.IOException;
import java.util.List;

/**
 * Parameters supplied to update Identity Provider.
 */
@Fluent
public final class IdentityProviderUpdateParameters implements JsonSerializable<IdentityProviderUpdateParameters> {
    /*
     * Identity Provider update properties.
     */
    private IdentityProviderUpdateProperties innerProperties;

    /**
     * Creates an instance of IdentityProviderUpdateParameters class.
     */
    public IdentityProviderUpdateParameters() {
    }

    /**
     * Get the innerProperties property: Identity Provider update properties.
     * 
     * @return the innerProperties value.
     */
    private IdentityProviderUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the clientId property: Client Id of the Application in the external Identity Provider. It is App ID for
     * Facebook login, Client ID for Google login, App ID for Microsoft.
     * 
     * @return the clientId value.
     */
    public String clientId() {
        return this.innerProperties() == null ? null : this.innerProperties().clientId();
    }

    /**
     * Set the clientId property: Client Id of the Application in the external Identity Provider. It is App ID for
     * Facebook login, Client ID for Google login, App ID for Microsoft.
     * 
     * @param clientId the clientId value to set.
     * @return the IdentityProviderUpdateParameters object itself.
     */
    public IdentityProviderUpdateParameters withClientId(String clientId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IdentityProviderUpdateProperties();
        }
        this.innerProperties().withClientId(clientId);
        return this;
    }

    /**
     * Get the clientSecret property: Client secret of the Application in external Identity Provider, used to
     * authenticate login request. For example, it is App Secret for Facebook login, API Key for Google login, Public
     * Key for Microsoft.
     * 
     * @return the clientSecret value.
     */
    public String clientSecret() {
        return this.innerProperties() == null ? null : this.innerProperties().clientSecret();
    }

    /**
     * Set the clientSecret property: Client secret of the Application in external Identity Provider, used to
     * authenticate login request. For example, it is App Secret for Facebook login, API Key for Google login, Public
     * Key for Microsoft.
     * 
     * @param clientSecret the clientSecret value to set.
     * @return the IdentityProviderUpdateParameters object itself.
     */
    public IdentityProviderUpdateParameters withClientSecret(String clientSecret) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IdentityProviderUpdateProperties();
        }
        this.innerProperties().withClientSecret(clientSecret);
        return this;
    }

    /**
     * Get the type property: Identity Provider Type identifier.
     * 
     * @return the type value.
     */
    public IdentityProviderType type() {
        return this.innerProperties() == null ? null : this.innerProperties().type();
    }

    /**
     * Set the type property: Identity Provider Type identifier.
     * 
     * @param type the type value to set.
     * @return the IdentityProviderUpdateParameters object itself.
     */
    public IdentityProviderUpdateParameters withType(IdentityProviderType type) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IdentityProviderUpdateProperties();
        }
        this.innerProperties().withType(type);
        return this;
    }

    /**
     * Get the signinTenant property: The TenantId to use instead of Common when logging into Active Directory.
     * 
     * @return the signinTenant value.
     */
    public String signinTenant() {
        return this.innerProperties() == null ? null : this.innerProperties().signinTenant();
    }

    /**
     * Set the signinTenant property: The TenantId to use instead of Common when logging into Active Directory.
     * 
     * @param signinTenant the signinTenant value to set.
     * @return the IdentityProviderUpdateParameters object itself.
     */
    public IdentityProviderUpdateParameters withSigninTenant(String signinTenant) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IdentityProviderUpdateProperties();
        }
        this.innerProperties().withSigninTenant(signinTenant);
        return this;
    }

    /**
     * Get the allowedTenants property: List of Allowed Tenants when configuring Azure Active Directory login.
     * 
     * @return the allowedTenants value.
     */
    public List<String> allowedTenants() {
        return this.innerProperties() == null ? null : this.innerProperties().allowedTenants();
    }

    /**
     * Set the allowedTenants property: List of Allowed Tenants when configuring Azure Active Directory login.
     * 
     * @param allowedTenants the allowedTenants value to set.
     * @return the IdentityProviderUpdateParameters object itself.
     */
    public IdentityProviderUpdateParameters withAllowedTenants(List<String> allowedTenants) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IdentityProviderUpdateProperties();
        }
        this.innerProperties().withAllowedTenants(allowedTenants);
        return this;
    }

    /**
     * Get the authority property: OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
     * 
     * @return the authority value.
     */
    public String authority() {
        return this.innerProperties() == null ? null : this.innerProperties().authority();
    }

    /**
     * Set the authority property: OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
     * 
     * @param authority the authority value to set.
     * @return the IdentityProviderUpdateParameters object itself.
     */
    public IdentityProviderUpdateParameters withAuthority(String authority) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IdentityProviderUpdateProperties();
        }
        this.innerProperties().withAuthority(authority);
        return this;
    }

    /**
     * Get the signupPolicyName property: Signup Policy Name. Only applies to AAD B2C Identity Provider.
     * 
     * @return the signupPolicyName value.
     */
    public String signupPolicyName() {
        return this.innerProperties() == null ? null : this.innerProperties().signupPolicyName();
    }

    /**
     * Set the signupPolicyName property: Signup Policy Name. Only applies to AAD B2C Identity Provider.
     * 
     * @param signupPolicyName the signupPolicyName value to set.
     * @return the IdentityProviderUpdateParameters object itself.
     */
    public IdentityProviderUpdateParameters withSignupPolicyName(String signupPolicyName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IdentityProviderUpdateProperties();
        }
        this.innerProperties().withSignupPolicyName(signupPolicyName);
        return this;
    }

    /**
     * Get the signinPolicyName property: Signin Policy Name. Only applies to AAD B2C Identity Provider.
     * 
     * @return the signinPolicyName value.
     */
    public String signinPolicyName() {
        return this.innerProperties() == null ? null : this.innerProperties().signinPolicyName();
    }

    /**
     * Set the signinPolicyName property: Signin Policy Name. Only applies to AAD B2C Identity Provider.
     * 
     * @param signinPolicyName the signinPolicyName value to set.
     * @return the IdentityProviderUpdateParameters object itself.
     */
    public IdentityProviderUpdateParameters withSigninPolicyName(String signinPolicyName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IdentityProviderUpdateProperties();
        }
        this.innerProperties().withSigninPolicyName(signinPolicyName);
        return this;
    }

    /**
     * Get the profileEditingPolicyName property: Profile Editing Policy Name. Only applies to AAD B2C Identity
     * Provider.
     * 
     * @return the profileEditingPolicyName value.
     */
    public String profileEditingPolicyName() {
        return this.innerProperties() == null ? null : this.innerProperties().profileEditingPolicyName();
    }

    /**
     * Set the profileEditingPolicyName property: Profile Editing Policy Name. Only applies to AAD B2C Identity
     * Provider.
     * 
     * @param profileEditingPolicyName the profileEditingPolicyName value to set.
     * @return the IdentityProviderUpdateParameters object itself.
     */
    public IdentityProviderUpdateParameters withProfileEditingPolicyName(String profileEditingPolicyName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IdentityProviderUpdateProperties();
        }
        this.innerProperties().withProfileEditingPolicyName(profileEditingPolicyName);
        return this;
    }

    /**
     * Get the passwordResetPolicyName property: Password Reset Policy Name. Only applies to AAD B2C Identity Provider.
     * 
     * @return the passwordResetPolicyName value.
     */
    public String passwordResetPolicyName() {
        return this.innerProperties() == null ? null : this.innerProperties().passwordResetPolicyName();
    }

    /**
     * Set the passwordResetPolicyName property: Password Reset Policy Name. Only applies to AAD B2C Identity Provider.
     * 
     * @param passwordResetPolicyName the passwordResetPolicyName value to set.
     * @return the IdentityProviderUpdateParameters object itself.
     */
    public IdentityProviderUpdateParameters withPasswordResetPolicyName(String passwordResetPolicyName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IdentityProviderUpdateProperties();
        }
        this.innerProperties().withPasswordResetPolicyName(passwordResetPolicyName);
        return this;
    }

    /**
     * Get the clientLibrary property: The client library to be used in the developer portal. Only applies to AAD and
     * AAD B2C Identity Provider.
     * 
     * @return the clientLibrary value.
     */
    public String clientLibrary() {
        return this.innerProperties() == null ? null : this.innerProperties().clientLibrary();
    }

    /**
     * Set the clientLibrary property: The client library to be used in the developer portal. Only applies to AAD and
     * AAD B2C Identity Provider.
     * 
     * @param clientLibrary the clientLibrary value to set.
     * @return the IdentityProviderUpdateParameters object itself.
     */
    public IdentityProviderUpdateParameters withClientLibrary(String clientLibrary) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IdentityProviderUpdateProperties();
        }
        this.innerProperties().withClientLibrary(clientLibrary);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IdentityProviderUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IdentityProviderUpdateParameters if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the IdentityProviderUpdateParameters.
     */
    public static IdentityProviderUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IdentityProviderUpdateParameters deserializedIdentityProviderUpdateParameters
                = new IdentityProviderUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedIdentityProviderUpdateParameters.innerProperties
                        = IdentityProviderUpdateProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIdentityProviderUpdateParameters;
        });
    }
}
