// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.IssueUpdateContractProperties;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Issue update Parameters.
 */
@Fluent
public final class IssueUpdateContract implements JsonSerializable<IssueUpdateContract> {
    /*
     * Issue entity Update contract properties.
     */
    private IssueUpdateContractProperties innerProperties;

    /**
     * Creates an instance of IssueUpdateContract class.
     */
    public IssueUpdateContract() {
    }

    /**
     * Get the innerProperties property: Issue entity Update contract properties.
     * 
     * @return the innerProperties value.
     */
    private IssueUpdateContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the title property: The issue title.
     * 
     * @return the title value.
     */
    public String title() {
        return this.innerProperties() == null ? null : this.innerProperties().title();
    }

    /**
     * Set the title property: The issue title.
     * 
     * @param title the title value to set.
     * @return the IssueUpdateContract object itself.
     */
    public IssueUpdateContract withTitle(String title) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IssueUpdateContractProperties();
        }
        this.innerProperties().withTitle(title);
        return this;
    }

    /**
     * Get the description property: Text describing the issue.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: Text describing the issue.
     * 
     * @param description the description value to set.
     * @return the IssueUpdateContract object itself.
     */
    public IssueUpdateContract withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IssueUpdateContractProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the userId property: A resource identifier for the user created the issue.
     * 
     * @return the userId value.
     */
    public String userId() {
        return this.innerProperties() == null ? null : this.innerProperties().userId();
    }

    /**
     * Set the userId property: A resource identifier for the user created the issue.
     * 
     * @param userId the userId value to set.
     * @return the IssueUpdateContract object itself.
     */
    public IssueUpdateContract withUserId(String userId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IssueUpdateContractProperties();
        }
        this.innerProperties().withUserId(userId);
        return this;
    }

    /**
     * Get the createdDate property: Date and time when the issue was created.
     * 
     * @return the createdDate value.
     */
    public OffsetDateTime createdDate() {
        return this.innerProperties() == null ? null : this.innerProperties().createdDate();
    }

    /**
     * Set the createdDate property: Date and time when the issue was created.
     * 
     * @param createdDate the createdDate value to set.
     * @return the IssueUpdateContract object itself.
     */
    public IssueUpdateContract withCreatedDate(OffsetDateTime createdDate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IssueUpdateContractProperties();
        }
        this.innerProperties().withCreatedDate(createdDate);
        return this;
    }

    /**
     * Get the state property: Status of the issue.
     * 
     * @return the state value.
     */
    public State state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    /**
     * Set the state property: Status of the issue.
     * 
     * @param state the state value to set.
     * @return the IssueUpdateContract object itself.
     */
    public IssueUpdateContract withState(State state) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IssueUpdateContractProperties();
        }
        this.innerProperties().withState(state);
        return this;
    }

    /**
     * Get the apiId property: A resource identifier for the API the issue was created for.
     * 
     * @return the apiId value.
     */
    public String apiId() {
        return this.innerProperties() == null ? null : this.innerProperties().apiId();
    }

    /**
     * Set the apiId property: A resource identifier for the API the issue was created for.
     * 
     * @param apiId the apiId value to set.
     * @return the IssueUpdateContract object itself.
     */
    public IssueUpdateContract withApiId(String apiId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IssueUpdateContractProperties();
        }
        this.innerProperties().withApiId(apiId);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IssueUpdateContract from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IssueUpdateContract if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the IssueUpdateContract.
     */
    public static IssueUpdateContract fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IssueUpdateContract deserializedIssueUpdateContract = new IssueUpdateContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedIssueUpdateContract.innerProperties = IssueUpdateContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIssueUpdateContract;
        });
    }
}
