// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

/**
 * The Key to be used to generate token for user.
 */
public enum KeyType {
    /**
     * Enum value primary.
     */
    PRIMARY("primary"),

    /**
     * Enum value secondary.
     */
    SECONDARY("secondary");

    /**
     * The actual serialized value for a KeyType instance.
     */
    private final String value;

    KeyType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a KeyType instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed KeyType object, or null if unable to parse.
     */
    public static KeyType fromString(String value) {
        if (value == null) {
            return null;
        }
        KeyType[] items = KeyType.values();
        for (KeyType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
