// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Create keyVault contract details.
 */
@Fluent
public class KeyVaultContractCreateProperties implements JsonSerializable<KeyVaultContractCreateProperties> {
    /*
     * Key vault secret identifier for fetching secret. Providing a versioned secret will prevent auto-refresh. This
     * requires API Management service to be configured with aka.ms/apimmsi
     */
    private String secretIdentifier;

    /*
     * Null for SystemAssignedIdentity or Client Id for UserAssignedIdentity , which will be used to access key vault
     * secret.
     */
    private String identityClientId;

    /**
     * Creates an instance of KeyVaultContractCreateProperties class.
     */
    public KeyVaultContractCreateProperties() {
    }

    /**
     * Get the secretIdentifier property: Key vault secret identifier for fetching secret. Providing a versioned secret
     * will prevent auto-refresh. This requires API Management service to be configured with aka.ms/apimmsi.
     * 
     * @return the secretIdentifier value.
     */
    public String secretIdentifier() {
        return this.secretIdentifier;
    }

    /**
     * Set the secretIdentifier property: Key vault secret identifier for fetching secret. Providing a versioned secret
     * will prevent auto-refresh. This requires API Management service to be configured with aka.ms/apimmsi.
     * 
     * @param secretIdentifier the secretIdentifier value to set.
     * @return the KeyVaultContractCreateProperties object itself.
     */
    public KeyVaultContractCreateProperties withSecretIdentifier(String secretIdentifier) {
        this.secretIdentifier = secretIdentifier;
        return this;
    }

    /**
     * Get the identityClientId property: Null for SystemAssignedIdentity or Client Id for UserAssignedIdentity , which
     * will be used to access key vault secret.
     * 
     * @return the identityClientId value.
     */
    public String identityClientId() {
        return this.identityClientId;
    }

    /**
     * Set the identityClientId property: Null for SystemAssignedIdentity or Client Id for UserAssignedIdentity , which
     * will be used to access key vault secret.
     * 
     * @param identityClientId the identityClientId value to set.
     * @return the KeyVaultContractCreateProperties object itself.
     */
    public KeyVaultContractCreateProperties withIdentityClientId(String identityClientId) {
        this.identityClientId = identityClientId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("secretIdentifier", this.secretIdentifier);
        jsonWriter.writeStringField("identityClientId", this.identityClientId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyVaultContractCreateProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyVaultContractCreateProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the KeyVaultContractCreateProperties.
     */
    public static KeyVaultContractCreateProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyVaultContractCreateProperties deserializedKeyVaultContractCreateProperties
                = new KeyVaultContractCreateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("secretIdentifier".equals(fieldName)) {
                    deserializedKeyVaultContractCreateProperties.secretIdentifier = reader.getString();
                } else if ("identityClientId".equals(fieldName)) {
                    deserializedKeyVaultContractCreateProperties.identityClientId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKeyVaultContractCreateProperties;
        });
    }
}
