// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Issue contract Update Properties.
 */
@Fluent
public final class KeyVaultLastAccessStatusContractProperties
    implements JsonSerializable<KeyVaultLastAccessStatusContractProperties> {
    /*
     * Last status code for sync and refresh of secret from key vault.
     */
    private String code;

    /*
     * Details of the error else empty.
     */
    private String message;

    /*
     * Last time secret was accessed. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by
     * the ISO 8601 standard.
     */
    private OffsetDateTime timestampUtc;

    /**
     * Creates an instance of KeyVaultLastAccessStatusContractProperties class.
     */
    public KeyVaultLastAccessStatusContractProperties() {
    }

    /**
     * Get the code property: Last status code for sync and refresh of secret from key vault.
     * 
     * @return the code value.
     */
    public String code() {
        return this.code;
    }

    /**
     * Set the code property: Last status code for sync and refresh of secret from key vault.
     * 
     * @param code the code value to set.
     * @return the KeyVaultLastAccessStatusContractProperties object itself.
     */
    public KeyVaultLastAccessStatusContractProperties withCode(String code) {
        this.code = code;
        return this;
    }

    /**
     * Get the message property: Details of the error else empty.
     * 
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Set the message property: Details of the error else empty.
     * 
     * @param message the message value to set.
     * @return the KeyVaultLastAccessStatusContractProperties object itself.
     */
    public KeyVaultLastAccessStatusContractProperties withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get the timestampUtc property: Last time secret was accessed. The date conforms to the following format:
     * `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @return the timestampUtc value.
     */
    public OffsetDateTime timestampUtc() {
        return this.timestampUtc;
    }

    /**
     * Set the timestampUtc property: Last time secret was accessed. The date conforms to the following format:
     * `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @param timestampUtc the timestampUtc value to set.
     * @return the KeyVaultLastAccessStatusContractProperties object itself.
     */
    public KeyVaultLastAccessStatusContractProperties withTimestampUtc(OffsetDateTime timestampUtc) {
        this.timestampUtc = timestampUtc;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("timeStampUtc",
            this.timestampUtc == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestampUtc));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyVaultLastAccessStatusContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyVaultLastAccessStatusContractProperties if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the KeyVaultLastAccessStatusContractProperties.
     */
    public static KeyVaultLastAccessStatusContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyVaultLastAccessStatusContractProperties deserializedKeyVaultLastAccessStatusContractProperties
                = new KeyVaultLastAccessStatusContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("code".equals(fieldName)) {
                    deserializedKeyVaultLastAccessStatusContractProperties.code = reader.getString();
                } else if ("message".equals(fieldName)) {
                    deserializedKeyVaultLastAccessStatusContractProperties.message = reader.getString();
                } else if ("timeStampUtc".equals(fieldName)) {
                    deserializedKeyVaultLastAccessStatusContractProperties.timestampUtc = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKeyVaultLastAccessStatusContractProperties;
        });
    }
}
