// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Indication whether or not the legacy Configuration API (v1) should be exposed on the API Management service. Value is
 * optional but must be 'Enabled' or 'Disabled'. If 'Disabled', legacy Configuration API (v1) will not be available for
 * self-hosted gateways. Default value is 'Enabled'.
 */
public final class LegacyApiState extends ExpandableStringEnum<LegacyApiState> {
    /**
     * Static value Enabled for LegacyApiState.
     */
    public static final LegacyApiState ENABLED = fromString("Enabled");

    /**
     * Static value Disabled for LegacyApiState.
     */
    public static final LegacyApiState DISABLED = fromString("Disabled");

    /**
     * Creates a new instance of LegacyApiState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public LegacyApiState() {
    }

    /**
     * Creates or finds a LegacyApiState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding LegacyApiState.
     */
    public static LegacyApiState fromString(String name) {
        return fromString(name, LegacyApiState.class);
    }

    /**
     * Gets known LegacyApiState values.
     * 
     * @return known LegacyApiState values.
     */
    public static Collection<LegacyApiState> values() {
        return values(LegacyApiState.class);
    }
}
