// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Logger type.
 */
public final class LoggerType extends ExpandableStringEnum<LoggerType> {
    /**
     * Static value azureEventHub for LoggerType.
     */
    public static final LoggerType AZURE_EVENT_HUB = fromString("azureEventHub");

    /**
     * Static value applicationInsights for LoggerType.
     */
    public static final LoggerType APPLICATION_INSIGHTS = fromString("applicationInsights");

    /**
     * Static value azureMonitor for LoggerType.
     */
    public static final LoggerType AZURE_MONITOR = fromString("azureMonitor");

    /**
     * Creates a new instance of LoggerType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public LoggerType() {
    }

    /**
     * Creates or finds a LoggerType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding LoggerType.
     */
    public static LoggerType fromString(String name) {
        return fromString(name, LoggerType.class);
    }

    /**
     * Gets known LoggerType values.
     * 
     * @return known LoggerType values.
     */
    public static Collection<LoggerType> values() {
        return values(LoggerType.class);
    }
}
