// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The HTTP method to be used.
 */
public final class Method extends ExpandableStringEnum<Method> {
    /**
     * Static value GET for Method.
     */
    public static final Method GET = fromString("GET");

    /**
     * Static value POST for Method.
     */
    public static final Method POST = fromString("POST");

    /**
     * Creates a new instance of Method value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public Method() {
    }

    /**
     * Creates or finds a Method from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding Method.
     */
    public static Method fromString(String name) {
        return fromString(name, Method.class);
    }

    /**
     * Gets known Method values.
     * 
     * @return known Method values.
     */
    public static Collection<Method> values() {
        return values(Method.class);
    }
}
