// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes an available API Management SKU.
 */
@Fluent
public final class MigrateToStv2Contract implements JsonSerializable<MigrateToStv2Contract> {
    /*
     * Mode of Migration to stv2. Default is PreserveIp.
     */
    private MigrateToStv2Mode mode;

    /**
     * Creates an instance of MigrateToStv2Contract class.
     */
    public MigrateToStv2Contract() {
    }

    /**
     * Get the mode property: Mode of Migration to stv2. Default is PreserveIp.
     * 
     * @return the mode value.
     */
    public MigrateToStv2Mode mode() {
        return this.mode;
    }

    /**
     * Set the mode property: Mode of Migration to stv2. Default is PreserveIp.
     * 
     * @param mode the mode value to set.
     * @return the MigrateToStv2Contract object itself.
     */
    public MigrateToStv2Contract withMode(MigrateToStv2Mode mode) {
        this.mode = mode;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("mode", this.mode == null ? null : this.mode.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MigrateToStv2Contract from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MigrateToStv2Contract if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MigrateToStv2Contract.
     */
    public static MigrateToStv2Contract fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MigrateToStv2Contract deserializedMigrateToStv2Contract = new MigrateToStv2Contract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("mode".equals(fieldName)) {
                    deserializedMigrateToStv2Contract.mode = MigrateToStv2Mode.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMigrateToStv2Contract;
        });
    }
}
