// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

/**
 * Invalid indicates the name provided does not match the resource provider’s naming requirements (incorrect length,
 * unsupported characters, etc.) AlreadyExists indicates that the name is already in use and is therefore unavailable.
 */
public enum NameAvailabilityReason {
    /**
     * Enum value Valid.
     */
    VALID("Valid"),

    /**
     * Enum value Invalid.
     */
    INVALID("Invalid"),

    /**
     * Enum value AlreadyExists.
     */
    ALREADY_EXISTS("AlreadyExists");

    /**
     * The actual serialized value for a NameAvailabilityReason instance.
     */
    private final String value;

    NameAvailabilityReason(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a NameAvailabilityReason instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed NameAvailabilityReason object, or null if unable to parse.
     */
    public static NameAvailabilityReason fromString(String value) {
        if (value == null) {
            return null;
        }
        NameAvailabilityReason[] items = NameAvailabilityReason.values();
        for (NameAvailabilityReason item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
