// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.NamedValueContractInner;
import java.util.List;

/**
 * An immutable client-side representation of NamedValueContract.
 */
public interface NamedValueContract {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the displayName property: Unique name of NamedValue. It may contain only letters, digits, period, dash, and
     * underscore characters.
     * 
     * @return the displayName value.
     */
    String displayName();

    /**
     * Gets the value property: Value of the NamedValue. Can contain policy expressions. It may not be empty or consist
     * only of whitespace. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get
     * the value.
     * 
     * @return the value value.
     */
    String value();

    /**
     * Gets the keyVault property: KeyVault location details of the namedValue.
     * 
     * @return the keyVault value.
     */
    KeyVaultContractProperties keyVault();

    /**
     * Gets the provisioningState property: The provisioning state.
     * 
     * @return the provisioningState value.
     */
    String provisioningState();

    /**
     * Gets the tags property: Optional tags that when provided can be used to filter the NamedValue list.
     * 
     * @return the tags value.
     */
    List<String> tags();

    /**
     * Gets the secret property: Determines whether the value is a secret and should be encrypted or not. Default value
     * is false.
     * 
     * @return the secret value.
     */
    Boolean secret();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.apimanagement.fluent.models.NamedValueContractInner object.
     * 
     * @return the inner object.
     */
    NamedValueContractInner innerModel();

    /**
     * The entirety of the NamedValueContract definition.
     */
    interface Definition
        extends DefinitionStages.Blank, DefinitionStages.WithParentResource, DefinitionStages.WithCreate {
    }

    /**
     * The NamedValueContract definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the NamedValueContract definition.
         */
        interface Blank extends WithParentResource {
        }

        /**
         * The stage of the NamedValueContract definition allowing to specify parent resource.
         */
        interface WithParentResource {
            /**
             * Specifies resourceGroupName, serviceName.
             * 
             * @param resourceGroupName The name of the resource group. The name is case insensitive.
             * @param serviceName The name of the API Management service.
             * @return the next definition stage.
             */
            WithCreate withExistingService(String resourceGroupName, String serviceName);
        }

        /**
         * The stage of the NamedValueContract definition which contains all the minimum required properties for the
         * resource to be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate
            extends DefinitionStages.WithTags, DefinitionStages.WithDisplayName, DefinitionStages.WithValue,
            DefinitionStages.WithKeyVault, DefinitionStages.WithSecret, DefinitionStages.WithIfMatch {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            NamedValueContract create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            NamedValueContract create(Context context);
        }

        /**
         * The stage of the NamedValueContract definition allowing to specify tags.
         */
        interface WithTags {
            /**
             * Specifies the tags property: Optional tags that when provided can be used to filter the NamedValue list..
             * 
             * @param tags Optional tags that when provided can be used to filter the NamedValue list.
             * @return the next definition stage.
             */
            WithCreate withTags(List<String> tags);
        }

        /**
         * The stage of the NamedValueContract definition allowing to specify displayName.
         */
        interface WithDisplayName {
            /**
             * Specifies the displayName property: Unique name of NamedValue. It may contain only letters, digits,
             * period, dash, and underscore characters..
             * 
             * @param displayName Unique name of NamedValue. It may contain only letters, digits, period, dash, and
             * underscore characters.
             * @return the next definition stage.
             */
            WithCreate withDisplayName(String displayName);
        }

        /**
         * The stage of the NamedValueContract definition allowing to specify value.
         */
        interface WithValue {
            /**
             * Specifies the value property: Value of the NamedValue. Can contain policy expressions. It may not be
             * empty or consist only of whitespace. This property will not be filled on 'GET' operations! Use
             * '/listSecrets' POST request to get the value..
             * 
             * @param value Value of the NamedValue. Can contain policy expressions. It may not be empty or consist only
             * of whitespace. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to
             * get the value.
             * @return the next definition stage.
             */
            WithCreate withValue(String value);
        }

        /**
         * The stage of the NamedValueContract definition allowing to specify keyVault.
         */
        interface WithKeyVault {
            /**
             * Specifies the keyVault property: KeyVault location details of the namedValue..
             * 
             * @param keyVault KeyVault location details of the namedValue.
             * @return the next definition stage.
             */
            WithCreate withKeyVault(KeyVaultContractCreateProperties keyVault);
        }

        /**
         * The stage of the NamedValueContract definition allowing to specify secret.
         */
        interface WithSecret {
            /**
             * Specifies the secret property: Determines whether the value is a secret and should be encrypted or not.
             * Default value is false..
             * 
             * @param secret Determines whether the value is a secret and should be encrypted or not. Default value is
             * false.
             * @return the next definition stage.
             */
            WithCreate withSecret(Boolean secret);
        }

        /**
         * The stage of the NamedValueContract definition allowing to specify ifMatch.
         */
        interface WithIfMatch {
            /**
             * Specifies the ifMatch property: ETag of the Entity. Not required when creating an entity, but required
             * when updating an entity..
             * 
             * @param ifMatch ETag of the Entity. Not required when creating an entity, but required when updating an
             * entity.
             * @return the next definition stage.
             */
            WithCreate withIfMatch(String ifMatch);
        }
    }

    /**
     * Begins update for the NamedValueContract resource.
     * 
     * @return the stage of resource update.
     */
    NamedValueContract.Update update();

    /**
     * The template for NamedValueContract update.
     */
    interface Update extends UpdateStages.WithTags, UpdateStages.WithDisplayName, UpdateStages.WithValue,
        UpdateStages.WithKeyVault, UpdateStages.WithSecret, UpdateStages.WithIfMatch {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        NamedValueContract apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        NamedValueContract apply(Context context);
    }

    /**
     * The NamedValueContract update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the NamedValueContract update allowing to specify tags.
         */
        interface WithTags {
            /**
             * Specifies the tags property: Optional tags that when provided can be used to filter the NamedValue list..
             * 
             * @param tags Optional tags that when provided can be used to filter the NamedValue list.
             * @return the next definition stage.
             */
            Update withTags(List<String> tags);
        }

        /**
         * The stage of the NamedValueContract update allowing to specify displayName.
         */
        interface WithDisplayName {
            /**
             * Specifies the displayName property: Unique name of NamedValue. It may contain only letters, digits,
             * period, dash, and underscore characters..
             * 
             * @param displayName Unique name of NamedValue. It may contain only letters, digits, period, dash, and
             * underscore characters.
             * @return the next definition stage.
             */
            Update withDisplayName(String displayName);
        }

        /**
         * The stage of the NamedValueContract update allowing to specify value.
         */
        interface WithValue {
            /**
             * Specifies the value property: Value of the NamedValue. Can contain policy expressions. It may not be
             * empty or consist only of whitespace..
             * 
             * @param value Value of the NamedValue. Can contain policy expressions. It may not be empty or consist only
             * of whitespace.
             * @return the next definition stage.
             */
            Update withValue(String value);
        }

        /**
         * The stage of the NamedValueContract update allowing to specify keyVault.
         */
        interface WithKeyVault {
            /**
             * Specifies the keyVault property: KeyVault location details of the namedValue..
             * 
             * @param keyVault KeyVault location details of the namedValue.
             * @return the next definition stage.
             */
            Update withKeyVault(KeyVaultContractCreateProperties keyVault);
        }

        /**
         * The stage of the NamedValueContract update allowing to specify secret.
         */
        interface WithSecret {
            /**
             * Specifies the secret property: Determines whether the value is a secret and should be encrypted or not.
             * Default value is false..
             * 
             * @param secret Determines whether the value is a secret and should be encrypted or not. Default value is
             * false.
             * @return the next definition stage.
             */
            Update withSecret(Boolean secret);
        }

        /**
         * The stage of the NamedValueContract update allowing to specify ifMatch.
         */
        interface WithIfMatch {
            /**
             * Specifies the ifMatch property: ETag of the Entity. ETag should match the current entity state from the
             * header response of the GET request or it should be * for unconditional update..
             * 
             * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of
             * the GET request or it should be * for unconditional update.
             * @return the next definition stage.
             */
            Update withIfMatch(String ifMatch);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    NamedValueContract refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    NamedValueContract refresh(Context context);

    /**
     * Gets the secret of the named value specified by its identifier.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the secret of the named value specified by its identifier.
     */
    Response<NamedValueSecretContract> listValueWithResponse(Context context);

    /**
     * Gets the secret of the named value specified by its identifier.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the secret of the named value specified by its identifier.
     */
    NamedValueSecretContract listValue();

    /**
     * Refresh the secret of the named value specified by its identifier.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return namedValue details.
     */
    NamedValueContract refreshSecret();

    /**
     * Refresh the secret of the named value specified by its identifier.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return namedValue details.
     */
    NamedValueContract refreshSecret(Context context);
}
