// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * NamedValue Entity Base Parameters set.
 */
@Fluent
public class NamedValueEntityBaseParameters implements JsonSerializable<NamedValueEntityBaseParameters> {
    /*
     * Optional tags that when provided can be used to filter the NamedValue list.
     */
    private List<String> tags;

    /*
     * Determines whether the value is a secret and should be encrypted or not. Default value is false.
     */
    private Boolean secret;

    /**
     * Creates an instance of NamedValueEntityBaseParameters class.
     */
    public NamedValueEntityBaseParameters() {
    }

    /**
     * Get the tags property: Optional tags that when provided can be used to filter the NamedValue list.
     * 
     * @return the tags value.
     */
    public List<String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Optional tags that when provided can be used to filter the NamedValue list.
     * 
     * @param tags the tags value to set.
     * @return the NamedValueEntityBaseParameters object itself.
     */
    public NamedValueEntityBaseParameters withTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the secret property: Determines whether the value is a secret and should be encrypted or not. Default value
     * is false.
     * 
     * @return the secret value.
     */
    public Boolean secret() {
        return this.secret;
    }

    /**
     * Set the secret property: Determines whether the value is a secret and should be encrypted or not. Default value
     * is false.
     * 
     * @param secret the secret value to set.
     * @return the NamedValueEntityBaseParameters object itself.
     */
    public NamedValueEntityBaseParameters withSecret(Boolean secret) {
        this.secret = secret;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("secret", this.secret);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NamedValueEntityBaseParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NamedValueEntityBaseParameters if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NamedValueEntityBaseParameters.
     */
    public static NamedValueEntityBaseParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NamedValueEntityBaseParameters deserializedNamedValueEntityBaseParameters
                = new NamedValueEntityBaseParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tags".equals(fieldName)) {
                    List<String> tags = reader.readArray(reader1 -> reader1.getString());
                    deserializedNamedValueEntityBaseParameters.tags = tags;
                } else if ("secret".equals(fieldName)) {
                    deserializedNamedValueEntityBaseParameters.secret = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNamedValueEntityBaseParameters;
        });
    }
}
